/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.ClasspathConfiguration;

public class StartupConfiguration {
    private final String providerClassName;
    private final ClasspathConfiguration classpathConfiguration;
    private final ClassLoaderConfiguration classLoaderConfiguration;
    private final boolean isForkRequested;
    private final boolean isInForkedVm;
    private final boolean redirectTestOutputToFile;

    public StartupConfiguration(String providerClassName, ClasspathConfiguration classpathConfiguration, ClassLoaderConfiguration classLoaderConfiguration, boolean forkRequested, boolean inForkedVm, boolean redirectTestOutputToFile) {
        this.providerClassName = providerClassName;
        this.classpathConfiguration = classpathConfiguration;
        this.classLoaderConfiguration = classLoaderConfiguration;
        this.isForkRequested = forkRequested;
        this.isInForkedVm = inForkedVm;
        this.redirectTestOutputToFile = redirectTestOutputToFile;
    }

    public static StartupConfiguration inForkedVm(String providerClassName, ClasspathConfiguration classpathConfiguration, ClassLoaderConfiguration classLoaderConfiguration) {
        return new StartupConfiguration(providerClassName, classpathConfiguration, classLoaderConfiguration, false, true, false);
    }

    public ClasspathConfiguration getClasspathConfiguration() {
        return this.classpathConfiguration;
    }

    public boolean useSystemClassLoader() {
        return this.classLoaderConfiguration.isUseSystemClassLoader() && (this.isInForkedVm || this.isForkRequested);
    }

    public boolean isManifestOnlyJarRequestedAndUsable() {
        return this.classLoaderConfiguration.isManifestOnlyJarRequestedAndUsable();
    }

    public boolean isRedirectTestOutputToFile() {
        return this.redirectTestOutputToFile;
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    public ClassLoaderConfiguration getClassLoaderConfiguration() {
        return this.classLoaderConfiguration;
    }
}

