/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testset;

import java.io.File;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.io.MatchPatterns;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.io.SelectorUtils;

public final class ResolvedTest {
    private static final String CLASS_FILE_EXTENSION = ".class";
    private static final String JAVA_FILE_EXTENSION = ".java";
    private static final String WILDCARD_PATH_PREFIX = "**/";
    private static final String WILDCARD_FILENAME_POSTFIX = ".*";
    private final String classPattern;
    private final String methodPattern;
    private final boolean isRegexTestClassPattern;
    private final boolean isRegexTestMethodPattern;
    private final String description;

    public ResolvedTest(String classPattern, String methodPattern, boolean isRegex) {
        classPattern = ResolvedTest.tryBlank(classPattern);
        methodPattern = ResolvedTest.tryBlank(methodPattern);
        this.description = ResolvedTest.description(classPattern, methodPattern, isRegex);
        if (isRegex && classPattern != null) {
            classPattern = ResolvedTest.wrapRegex(classPattern);
        }
        if (isRegex && methodPattern != null) {
            methodPattern = ResolvedTest.wrapRegex(methodPattern);
        }
        this.classPattern = ResolvedTest.reformatClassPattern(classPattern, isRegex);
        this.methodPattern = methodPattern;
        this.isRegexTestClassPattern = isRegex;
        this.isRegexTestMethodPattern = isRegex;
    }

    public ResolvedTest(Type type, String pattern, boolean isRegex) {
        pattern = ResolvedTest.tryBlank(pattern);
        boolean isClass = type == Type.CLASS;
        this.description = ResolvedTest.description(isClass ? pattern : null, !isClass ? pattern : null, isRegex);
        if (isRegex && pattern != null) {
            pattern = ResolvedTest.wrapRegex(pattern);
        }
        this.classPattern = isClass ? ResolvedTest.reformatClassPattern(pattern, isRegex) : null;
        this.methodPattern = !isClass ? pattern : null;
        this.isRegexTestClassPattern = isRegex && isClass;
        this.isRegexTestMethodPattern = isRegex && !isClass;
    }

    public String getTestClassPattern() {
        return this.classPattern;
    }

    public boolean hasTestClassPattern() {
        return this.classPattern != null;
    }

    public String getTestMethodPattern() {
        return this.methodPattern;
    }

    public boolean hasTestMethodPattern() {
        return this.methodPattern != null;
    }

    public boolean isRegexTestClassPattern() {
        return this.isRegexTestClassPattern;
    }

    public boolean isRegexTestMethodPattern() {
        return this.isRegexTestMethodPattern;
    }

    public boolean isEmpty() {
        return this.classPattern == null && this.methodPattern == null;
    }

    public boolean shouldRun(String testClassFile, String methodName) {
        if (this.isEmpty()) {
            return true;
        }
        boolean matchedMethodPattern = false;
        if (this.methodPattern != null && methodName != null) {
            if (SelectorUtils.matchPath(this.methodPattern, methodName)) {
                matchedMethodPattern = true;
            } else {
                return false;
            }
        }
        if (this.classPattern != null) {
            return this.isRegexTestClassPattern ? this.matchClassRegexPatter(testClassFile) : this.matchClassPatter(testClassFile);
        }
        return matchedMethodPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedTest that = (ResolvedTest)o;
        return (this.classPattern == null ? that.classPattern == null : this.classPattern.equals(that.classPattern)) && (this.methodPattern == null ? that.methodPattern == null : this.methodPattern.equals(that.methodPattern));
    }

    public int hashCode() {
        int result = this.classPattern != null ? this.classPattern.hashCode() : 0;
        result = 31 * result + (this.methodPattern != null ? this.methodPattern.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.isEmpty() ? null : this.description;
    }

    private static String description(String clazz, String method, boolean isRegex) {
        String description = clazz == null && method == null ? null : (clazz == null ? "#" + method : (method == null ? clazz : clazz + "#" + method));
        return isRegex && description != null ? ResolvedTest.wrapRegex(description) : description;
    }

    private boolean matchClassPatter(String testClassFile) {
        String classPattern = this.classPattern;
        if (File.separatorChar != '/') {
            testClassFile = testClassFile.replace('/', File.separatorChar);
            classPattern = classPattern.replace('/', File.separatorChar);
        }
        if (classPattern.endsWith(WILDCARD_FILENAME_POSTFIX) || classPattern.endsWith(CLASS_FILE_EXTENSION)) {
            return MatchPatterns.from(classPattern).matches(testClassFile, true);
        }
        String[] classPatterns = new String[]{classPattern + CLASS_FILE_EXTENSION, classPattern};
        return MatchPatterns.from(classPatterns).matches(testClassFile, true);
    }

    private boolean matchClassRegexPatter(String testClassFile) {
        if (File.separatorChar != '/') {
            testClassFile = testClassFile.replace('/', File.separatorChar);
        }
        return MatchPatterns.from(this.classPattern).matches(testClassFile, true);
    }

    private static String tryBlank(String s) {
        if (s == null) {
            return null;
        }
        return StringUtils.isEmpty(s = s.trim()) ? null : s;
    }

    private static String reformatClassPattern(String s, boolean isRegex) {
        if (s != null && !isRegex && (s = ResolvedTest.convertToPath(s)) != null && !s.startsWith(WILDCARD_PATH_PREFIX)) {
            s = WILDCARD_PATH_PREFIX + s;
        }
        return s;
    }

    private static String convertToPath(String className) {
        if (StringUtils.isBlank(className)) {
            return null;
        }
        if (className.endsWith(JAVA_FILE_EXTENSION)) {
            className = className.substring(0, className.length() - JAVA_FILE_EXTENSION.length());
            className = className + CLASS_FILE_EXTENSION;
        }
        return className;
    }

    static String wrapRegex(String unwrapped) {
        return "%regex[" + unwrapped + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CLASS,
        METHOD;

    }
}

