/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.surefire.booter.Classpath;

public class SurefireDependencyResolver {
    private final ArtifactResolver artifactResolver;
    private final ArtifactFactory artifactFactory;
    private final Log log;
    private final ArtifactRepository localRepository;
    private final List remoteRepositories;
    private final ArtifactMetadataSource artifactMetadataSource;
    private final String pluginName;

    protected SurefireDependencyResolver(ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, Log log, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource artifactMetadataSource, String pluginName) {
        this.artifactResolver = artifactResolver;
        this.artifactFactory = artifactFactory;
        this.log = log;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
        this.artifactMetadataSource = artifactMetadataSource;
        this.pluginName = pluginName;
    }

    public boolean isWithinVersionSpec(Artifact artifact, String versionSpec) {
        if (artifact == null) {
            return false;
        }
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)versionSpec);
            try {
                return range.containsVersion(artifact.getSelectedVersion());
            }
            catch (NullPointerException e) {
                return range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getBaseVersion()));
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException("Bug in plugin. Please report with stacktrace");
        }
        catch (OverConstrainedVersionException e) {
            throw new RuntimeException("Bug in plugin. Please report with stacktrace");
        }
    }

    public Set filterArtifacts(Set artifacts, ArtifactFilter filter) {
        LinkedHashSet<Artifact> filteredArtifacts = new LinkedHashSet<Artifact>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (filter.include(artifact)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    public ArtifactResolutionResult resolveArtifact(Artifact filteredArtifact, Artifact providerArtifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        ExcludesArtifactFilter filter = null;
        if (filteredArtifact != null) {
            filter = new ExcludesArtifactFilter(Collections.singletonList(filteredArtifact.getGroupId() + ":" + filteredArtifact.getArtifactId()));
        }
        Artifact originatingArtifact = this.artifactFactory.createBuildArtifact("dummy", "dummy", "1.0", "jar");
        return this.artifactResolver.resolveTransitively(Collections.singleton(providerArtifact), originatingArtifact, this.localRepository, this.remoteRepositories, this.artifactMetadataSource, (ArtifactFilter)filter);
    }

    public Classpath getProviderClasspath(String provider, String version, Artifact filteredArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        Artifact providerArtifact = this.artifactFactory.createDependencyArtifact("org.apache.maven.surefire", provider, VersionRange.createFromVersion((String)version), "jar", null, "test");
        ArtifactResolutionResult result = this.resolveArtifact(filteredArtifact, providerArtifact);
        ArrayList<String> files = new ArrayList<String>();
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.log.debug((CharSequence)("Adding to " + this.pluginName + " test classpath: " + artifact.getFile().getAbsolutePath() + " Scope: " + artifact.getScope()));
            files.add(artifact.getFile().getAbsolutePath());
        }
        return new Classpath(files);
    }

    public Classpath addProviderToClasspath(Map pluginArtifactMap, Artifact surefireArtifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArrayList<String> files = new ArrayList<String>();
        if (surefireArtifact != null) {
            ArtifactResolutionResult artifactResolutionResult = this.resolveArtifact(null, surefireArtifact);
            Iterator iterator = pluginArtifactMap.values().iterator();
            while (iterator.hasNext()) {
                Artifact artifact = (Artifact)iterator.next();
                if (artifactResolutionResult.getArtifacts().contains(artifact)) continue;
                files.add(artifact.getFile().getAbsolutePath());
            }
        } else {
            Iterator iterator = pluginArtifactMap.values().iterator();
            while (iterator.hasNext()) {
                Artifact artifact = (Artifact)iterator.next();
                files.add(artifact.getFile().getPath());
            }
        }
        return new Classpath(files);
    }

    public Classpath getResolvedArtifactClasspath(Artifact surefireArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        ArtifactResolutionResult result = this.resolveArtifact(null, surefireArtifact);
        ArrayList<String> classpath = new ArrayList<String>();
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            classpath.add(artifact.getFile().getAbsolutePath());
        }
        return new Classpath(classpath);
    }
}

