/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.surefire.util.ScannerUtil;
import org.apache.maven.surefire.testset.TestFilter;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.util.DefaultScanResult;

public class DependencyScanner {
    private final List<File> dependenciesToScan;
    private final TestListResolver filter;

    public DependencyScanner(List<File> dependenciesToScan, TestListResolver filter) {
        this.dependenciesToScan = dependenciesToScan;
        this.filter = filter;
    }

    public DefaultScanResult scan() throws MojoExecutionException {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        for (File artifact : this.dependenciesToScan) {
            try {
                DependencyScanner.scanArtifact(artifact, (TestFilter<String, String>)this.filter, classes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not scan dependency " + artifact.toString(), (Exception)e);
            }
        }
        return new DefaultScanResult(new ArrayList(classes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanArtifact(File artifact, TestFilter<String, String> filter, Set<String> classes) throws IOException {
        if (artifact != null && artifact.isFile()) {
            JarFile jar = null;
            try {
                jar = new JarFile(artifact);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!filter.shouldRun((Object)entry.getName(), null)) continue;
                    classes.add(ScannerUtil.convertJarFileResourceToJavaClassName(entry.getName()));
                }
            }
            finally {
                if (jar != null) {
                    jar.close();
                }
            }
        }
    }

    public static List<File> filter(List<Artifact> artifacts, List<String> groupArtifactIds) {
        ArrayList<File> matches = new ArrayList<File>();
        if (groupArtifactIds == null || artifacts == null) {
            return matches;
        }
        for (Artifact artifact : artifacts) {
            for (String groups : groupArtifactIds) {
                String[] groupArtifact = groups.split(":");
                if (groupArtifact.length != 2) {
                    throw new IllegalArgumentException("dependencyToScan argument should be in format 'groupid:artifactid': " + groups);
                }
                if (!artifact.getGroupId().matches(groupArtifact[0]) || !artifact.getArtifactId().matches(groupArtifact[1])) continue;
                matches.add(artifact.getFile());
            }
        }
        return matches;
    }
}

