/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.maven.plugin.surefire.report.FileReporter;
import org.apache.maven.plugin.surefire.report.TestcycleConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;

public class ConsoleOutputFileReporter
implements TestcycleConsoleOutputReceiver {
    private final File reportsDirectory;
    private final String reportNameSuffix;
    private String reportEntryName;
    private OutputStream fileOutputStream;

    public ConsoleOutputFileReporter(File reportsDirectory, String reportNameSuffix) {
        this.reportsDirectory = reportsDirectory;
        this.reportNameSuffix = reportNameSuffix;
    }

    @Override
    public void testSetStarting(ReportEntry reportEntry) {
        this.close();
        this.reportEntryName = reportEntry.getName();
    }

    @Override
    public void testSetCompleted(ReportEntry report) {
    }

    @Override
    public void close() {
        if (this.fileOutputStream != null) {
            try {
                this.fileOutputStream.flush();
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.fileOutputStream = null;
        }
    }

    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        try {
            if (this.fileOutputStream == null) {
                if (!this.reportsDirectory.exists()) {
                    this.reportsDirectory.mkdirs();
                }
                File file = FileReporter.getReportFile(this.reportsDirectory, this.reportEntryName, this.reportNameSuffix, "-output.txt");
                this.fileOutputStream = new BufferedOutputStream(new FileOutputStream(file), 16384);
            }
            this.fileOutputStream.write(buf, off, len);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

