/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.scriptinterpreter;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.shared.scriptinterpreter.BeanShellScriptInterpreter;
import org.apache.maven.shared.scriptinterpreter.ExecutionLogger;
import org.apache.maven.shared.scriptinterpreter.GroovyScriptInterpreter;
import org.apache.maven.shared.scriptinterpreter.ScriptEvaluationException;
import org.apache.maven.shared.scriptinterpreter.ScriptException;
import org.apache.maven.shared.scriptinterpreter.ScriptInterpreter;
import org.apache.maven.shared.scriptinterpreter.ScriptReturnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptRunner.class);
    private Map<String, ScriptInterpreter> scriptInterpreters = new LinkedHashMap<String, ScriptInterpreter>();
    private Map<String, Object> globalVariables;
    private List<String> classPath;
    private String encoding;

    public ScriptRunner() {
        this.scriptInterpreters.put("bsh", new BeanShellScriptInterpreter());
        this.scriptInterpreters.put("groovy", new GroovyScriptInterpreter());
        this.globalVariables = new HashMap<String, Object>();
        this.classPath = new ArrayList<String>();
    }

    public void addScriptInterpreter(String id, ScriptInterpreter scriptInterpreter) {
        this.scriptInterpreters.put(id, scriptInterpreter);
    }

    public void setGlobalVariable(String name, Object value) {
        this.globalVariables.put(name, value);
    }

    public void setClassPath(List<String> classPath) {
        this.classPath = classPath != null ? new ArrayList<String>(classPath) : new ArrayList();
    }

    public void setScriptEncoding(String encoding) {
        this.encoding = encoding != null && encoding.length() > 0 ? encoding : null;
    }

    public void run(String scriptDescription, File basedir, String relativeScriptPath, Map<String, ?> context, ExecutionLogger logger) throws IOException, ScriptException {
        if (relativeScriptPath == null) {
            LOG.debug("{}: relativeScriptPath is null, not executing script", (Object)scriptDescription);
            return;
        }
        File scriptFile = this.resolveScript(new File(basedir, relativeScriptPath));
        if (!scriptFile.exists()) {
            LOG.debug("{} : no script '{}' found in directory {}", new Object[]{scriptDescription, relativeScriptPath, basedir.getAbsolutePath()});
            return;
        }
        LOG.info("run {} {}.{}", new Object[]{scriptDescription, relativeScriptPath, FilenameUtils.getExtension((String)scriptFile.getAbsolutePath())});
        this.executeRun(scriptDescription, scriptFile, context, logger);
    }

    public void run(String scriptDescription, File scriptFile, Map<String, ?> context, ExecutionLogger logger) throws IOException, ScriptException {
        if (!scriptFile.exists()) {
            LOG.debug("{} : script file not found in directory {}", (Object)scriptDescription, (Object)scriptFile.getAbsolutePath());
            return;
        }
        LOG.info("run {} {}", (Object)scriptDescription, (Object)scriptFile.getAbsolutePath());
        this.executeRun(scriptDescription, scriptFile, context, logger);
    }

    private void executeRun(String scriptDescription, File scriptFile, Map<String, ?> context, ExecutionLogger logger) throws IOException, ScriptException {
        Object result;
        String script;
        ScriptInterpreter interpreter = this.getInterpreter(scriptFile);
        if (LOG.isDebugEnabled()) {
            String name = interpreter.getClass().getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            LOG.debug("Running script with {} :{}", (Object)name, (Object)scriptFile);
        }
        try {
            byte[] bytes = Files.readAllBytes(scriptFile.toPath());
            script = this.encoding != null ? new String(bytes, this.encoding) : new String(bytes);
        }
        catch (IOException e) {
            String errorMessage = "error reading " + scriptDescription + " " + scriptFile.getPath() + ", " + e.getMessage();
            throw new IOException(errorMessage, e);
        }
        try {
            if (logger != null) {
                logger.consumeLine("Running " + scriptDescription + ": " + scriptFile);
            }
            PrintStream out = logger != null ? logger.getPrintStream() : null;
            HashMap<String, Object> scriptVariables = new HashMap<String, Object>(this.globalVariables);
            scriptVariables.put("basedir", scriptFile.getParentFile());
            scriptVariables.put("context", context);
            result = interpreter.evaluateScript(script, this.classPath, scriptVariables, out);
            if (logger != null) {
                logger.consumeLine("Finished " + scriptDescription + ": " + scriptFile);
            }
        }
        catch (ScriptEvaluationException e) {
            Throwable t;
            Throwable throwable = t = e.getCause() != null ? e.getCause() : e;
            if (logger != null) {
                t.printStackTrace(logger.getPrintStream());
            }
            throw e;
        }
        if (result != null && !Boolean.parseBoolean(String.valueOf(result))) {
            throw new ScriptReturnException("The " + scriptDescription + " returned " + result + ".", result);
        }
    }

    private File resolveScript(File scriptFile) {
        if (scriptFile != null && !scriptFile.exists()) {
            for (String ext : this.scriptInterpreters.keySet()) {
                File candidateFile = new File(scriptFile.getPath() + '.' + ext);
                if (!candidateFile.exists()) continue;
                scriptFile = candidateFile;
                break;
            }
        }
        return scriptFile;
    }

    private ScriptInterpreter getInterpreter(File scriptFile) {
        String ext = FilenameUtils.getExtension((String)scriptFile.getName()).toLowerCase(Locale.ENGLISH);
        ScriptInterpreter interpreter = this.scriptInterpreters.get(ext);
        if (interpreter == null) {
            interpreter = this.scriptInterpreters.get("bsh");
        }
        return interpreter;
    }
}

