/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.test.plugin;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.test.plugin.TestToolsException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class RepositoryTool
implements Contextualizable {
    public static final String ROLE = RepositoryTool.class.getName();
    private ArtifactRepositoryFactory repositoryFactory;
    private MavenSettingsBuilder settingsBuilder;
    private ArtifactFactory artifactFactory;
    private ArtifactInstaller artifactInstaller;
    private PlexusContainer container;

    public File findLocalRepositoryDirectory() throws TestToolsException {
        Settings settings;
        try {
            settings = this.settingsBuilder.buildSettings();
        }
        catch (IOException e) {
            throw new TestToolsException("Error building Maven settings.", e);
        }
        catch (XmlPullParserException e) {
            throw new TestToolsException("Error building Maven settings.", e);
        }
        if (settings == null || settings.getLocalRepository() == null || settings.getLocalRepository().trim().length() < 1) {
            return new File(System.getProperty("user.home"), ".m2/repository");
        }
        return new File(settings.getLocalRepository());
    }

    public ArtifactRepository createLocalArtifactRepositoryInstance() throws TestToolsException {
        File localRepoDir = this.findLocalRepositoryDirectory();
        return this.createLocalArtifactRepositoryInstance(localRepoDir);
    }

    public ArtifactRepository createLocalArtifactRepositoryInstance(File localRepositoryDirectory) throws TestToolsException {
        ArtifactRepositoryLayout defaultLayout;
        try {
            defaultLayout = (ArtifactRepositoryLayout)this.container.lookup(ArtifactRepositoryLayout.ROLE, "default");
        }
        catch (ComponentLookupException e) {
            throw new TestToolsException("Error retrieving default repository layout.", e);
        }
        try {
            return this.repositoryFactory.createArtifactRepository("local", localRepositoryDirectory.toURL().toExternalForm(), defaultLayout, null, null);
        }
        catch (MalformedURLException e) {
            throw new TestToolsException("Error converting local repo directory to a URL.", e);
        }
    }

    public void createLocalRepositoryFromComponentProject(MavenProject project, File realPomFile, File targetLocalRepoBasedir) throws TestToolsException {
        Artifact artifact = project.getArtifact();
        if ("pom".equals(project.getPackaging())) {
            artifact.setFile(project.getFile());
        }
        ArtifactRepository localRepository = this.createLocalArtifactRepositoryInstance(targetLocalRepoBasedir);
        String localPath = localRepository.pathOf(artifact);
        File destination = new File(localRepository.getBasedir(), localPath);
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        try {
            this.artifactInstaller.install(artifact.getFile(), artifact, localRepository);
        }
        catch (ArtifactInstallationException e) {
            throw new TestToolsException("Error installing plugin artifact to target local repository: " + targetLocalRepoBasedir, e);
        }
        this.installLocallyReachableAncestorPoms(realPomFile, localRepository);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void installLocallyReachableAncestorPoms(File realPomFile, ArtifactRepository localRepo) throws TestToolsException {
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        File pom = realPomFile;
        boolean firstPass = true;
        while (true) {
            File currentPom;
            FileReader reader;
            String pomVersion;
            String pomArtifactId;
            String pomGroupId;
            block14: {
                if (pom == null) {
                    return;
                }
                if (!pom.exists()) {
                    return;
                }
                pomGroupId = null;
                pomArtifactId = null;
                pomVersion = null;
                reader = null;
                currentPom = pom;
                try {
                    reader = new FileReader(pom);
                    Model model = pomReader.read((Reader)reader);
                    pomGroupId = model.getGroupId();
                    pomArtifactId = model.getArtifactId();
                    pomVersion = model.getVersion();
                    Parent parent = model.getParent();
                    if (parent != null) {
                        pom = new File(pom.getParentFile(), parent.getRelativePath());
                        if (pomGroupId == null) {
                            pomGroupId = parent.getGroupId();
                        }
                        if (pomVersion == null) {
                            pomVersion = parent.getVersion();
                        }
                        break block14;
                    }
                    pom = null;
                }
                catch (IOException e) {
                    try {
                        throw new TestToolsException("Error reading ancestor POM: " + currentPom, e);
                        catch (XmlPullParserException e2) {
                            throw new TestToolsException("Error reading ancestor POM: " + currentPom, e2);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(reader);
                        throw throwable;
                    }
                }
            }
            IOUtil.close((Reader)reader);
            if (!firstPass) {
                Artifact pomArtifact = this.artifactFactory.createProjectArtifact(pomGroupId, pomArtifactId, pomVersion);
                pomArtifact.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(pomArtifact, currentPom));
                try {
                    this.artifactInstaller.install(currentPom, pomArtifact, localRepo);
                }
                catch (ArtifactInstallationException e) {
                    throw new TestToolsException("Error installing ancestor POM: " + currentPom + " to target local repository: " + localRepo.getBasedir(), e);
                }
            }
            firstPass = false;
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

