/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.config;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Scm;
import org.apache.maven.shared.release.config.ModelloReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseDescriptorBuilder {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{[^}]+}");
    private final Logger logger;
    private final BuilderReleaseDescriptor releaseDescriptor = new BuilderReleaseDescriptor();

    public ReleaseDescriptorBuilder() {
        this(LoggerFactory.getLogger(ReleaseDescriptorBuilder.class));
    }

    ReleaseDescriptorBuilder(Logger logger) {
        this.releaseDescriptor.setLineSeparator(ReleaseUtil.LS);
        this.logger = logger;
    }

    public ReleaseDescriptorBuilder addCheckModificationExclude(String string) {
        this.releaseDescriptor.addCheckModificationExclude(string);
        return this;
    }

    public ReleaseDescriptorBuilder setActivateProfiles(List<String> profiles) {
        this.releaseDescriptor.setActivateProfiles(profiles);
        return this;
    }

    public ReleaseDescriptorBuilder setAddSchema(boolean addSchema) {
        this.releaseDescriptor.setAddSchema(addSchema);
        return this;
    }

    public ReleaseDescriptorBuilder setAdditionalArguments(String additionalArguments) {
        if (additionalArguments != null) {
            Matcher matcher = PROPERTY_PATTERN.matcher(additionalArguments);
            StringBuffer buf = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(buf, "");
                this.logger.warn("arguments parameter contains unresolved property: '{}'", (Object)matcher.group());
            }
            matcher.appendTail(buf);
            this.releaseDescriptor.setAdditionalArguments(buf.toString());
        } else {
            this.releaseDescriptor.setAdditionalArguments(null);
        }
        return this;
    }

    public ReleaseDescriptorBuilder setAllowTimestampedSnapshots(boolean allowTimestampedSnapshots) {
        this.releaseDescriptor.setAllowTimestampedSnapshots(allowTimestampedSnapshots);
        return this;
    }

    public ReleaseDescriptorBuilder setAutoVersionSubmodules(boolean autoVersionSubmodules) {
        this.releaseDescriptor.setAutoVersionSubmodules(autoVersionSubmodules);
        return this;
    }

    public ReleaseDescriptorBuilder setBranchCreation(boolean branchCreation) {
        this.releaseDescriptor.setBranchCreation(branchCreation);
        return this;
    }

    public ReleaseDescriptorBuilder setCheckModificationExcludes(List<String> checkModificationExcludes) {
        this.releaseDescriptor.setCheckModificationExcludes(checkModificationExcludes);
        return this;
    }

    public ReleaseDescriptorBuilder setCheckoutDirectory(String checkoutDirectory) {
        this.releaseDescriptor.setCheckoutDirectory(checkoutDirectory);
        return this;
    }

    public ReleaseDescriptorBuilder setCommitByProject(boolean commitByProject) {
        this.releaseDescriptor.setCommitByProject(commitByProject);
        return this;
    }

    public ReleaseDescriptorBuilder setCompletedPhase(String completedPhase) {
        this.releaseDescriptor.setCompletedPhase(completedPhase);
        return this;
    }

    public ReleaseDescriptorBuilder setCompletionGoals(String completionGoals) {
        this.releaseDescriptor.setCompletionGoals(completionGoals);
        return this;
    }

    public ReleaseDescriptorBuilder setDefaultDevelopmentVersion(String defaultDevelopmentVersion) {
        this.releaseDescriptor.setDefaultDevelopmentVersion(defaultDevelopmentVersion);
        return this;
    }

    public ReleaseDescriptorBuilder setDefaultReleaseVersion(String defaultReleaseVersion) {
        this.releaseDescriptor.setDefaultReleaseVersion(defaultReleaseVersion);
        return this;
    }

    public ReleaseDescriptorBuilder setDescription(String description) {
        this.releaseDescriptor.setDescription(description);
        return this;
    }

    public ReleaseDescriptorBuilder setGenerateReleasePoms(boolean generateReleasePoms) {
        this.releaseDescriptor.setGenerateReleasePoms(generateReleasePoms);
        return this;
    }

    public ReleaseDescriptorBuilder setInteractive(boolean interactive) {
        this.releaseDescriptor.setInteractive(interactive);
        return this;
    }

    public ReleaseDescriptorBuilder setLineSeparator(String ls) {
        this.releaseDescriptor.setLineSeparator(ls);
        return this;
    }

    public ReleaseDescriptorBuilder setLocalCheckout(boolean localCheckout) {
        this.releaseDescriptor.setLocalCheckout(localCheckout);
        return this;
    }

    public ReleaseDescriptorBuilder setModelEncoding(String modelEncoding) {
        this.releaseDescriptor.setModelEncoding(modelEncoding);
        return this;
    }

    public ReleaseDescriptorBuilder setName(String name) {
        this.releaseDescriptor.setName(name);
        return this;
    }

    public ReleaseDescriptorBuilder setPerformGoals(String performGoals) {
        this.releaseDescriptor.setPerformGoals(performGoals);
        return this;
    }

    public ReleaseDescriptorBuilder setPomFileName(String pomFileName) {
        this.releaseDescriptor.setPomFileName(pomFileName);
        return this;
    }

    public ReleaseDescriptorBuilder setPreparationGoals(String preparationGoals) {
        this.releaseDescriptor.setPreparationGoals(preparationGoals);
        return this;
    }

    public ReleaseDescriptorBuilder setProjectNamingPolicyId(String projectNamingPolicyId) {
        this.releaseDescriptor.setProjectNamingPolicyId(projectNamingPolicyId);
        return this;
    }

    public ReleaseDescriptorBuilder setProjectVersionPolicyId(String projectVersionPolicyId) {
        this.releaseDescriptor.setProjectVersionPolicyId(projectVersionPolicyId);
        return this;
    }

    public ReleaseDescriptorBuilder setProjectVersionPolicyConfig(String setProjectVersionPolicyConfig) {
        this.releaseDescriptor.setProjectVersionPolicyConfig(setProjectVersionPolicyConfig);
        return this;
    }

    public ReleaseDescriptorBuilder setPushChanges(boolean pushChanges) {
        this.releaseDescriptor.setPushChanges(pushChanges);
        return this;
    }

    public ReleaseDescriptorBuilder setWorkItem(String workItem) {
        this.releaseDescriptor.setWorkItem(workItem);
        return this;
    }

    public ReleaseDescriptorBuilder setReleaseStrategyId(String releaseStrategyId) {
        this.releaseDescriptor.setReleaseStrategyId(releaseStrategyId);
        return this;
    }

    public ReleaseDescriptorBuilder setRemoteTagging(boolean remoteTagging) {
        this.releaseDescriptor.setRemoteTagging(remoteTagging);
        return this;
    }

    public ReleaseDescriptorBuilder setScmBranchBase(String scmBranchBase) {
        this.releaseDescriptor.setScmBranchBase(scmBranchBase);
        return this;
    }

    public ReleaseDescriptorBuilder setScmCommentPrefix(String scmCommentPrefix) {
        this.releaseDescriptor.setScmCommentPrefix(scmCommentPrefix);
        return this;
    }

    public ReleaseDescriptorBuilder setScmShallowClone(boolean scmShallowClone) {
        this.releaseDescriptor.setScmShallowClone(scmShallowClone);
        return this;
    }

    public ReleaseDescriptorBuilder setScmReleaseCommitComment(String scmReleaseCommitComment) {
        this.releaseDescriptor.setScmReleaseCommitComment(scmReleaseCommitComment);
        return this;
    }

    public ReleaseDescriptorBuilder setScmDevelopmentCommitComment(String scmDevelopmentCommitComment) {
        this.releaseDescriptor.setScmDevelopmentCommitComment(scmDevelopmentCommitComment);
        return this;
    }

    public ReleaseDescriptorBuilder setScmBranchCommitComment(String scmBranchCommitComment) {
        this.releaseDescriptor.setScmBranchCommitComment(scmBranchCommitComment);
        return this;
    }

    public ReleaseDescriptorBuilder setScmRollbackCommitComment(String scmRollbackCommitComment) {
        this.releaseDescriptor.setScmRollbackCommitComment(scmRollbackCommitComment);
        return this;
    }

    public ReleaseDescriptorBuilder setScmId(String scmId) {
        this.releaseDescriptor.setScmId(scmId);
        return this;
    }

    public ReleaseDescriptorBuilder setScmPassword(String scmPassword) {
        this.releaseDescriptor.setScmPassword(scmPassword);
        return this;
    }

    public ReleaseDescriptorBuilder setScmPrivateKey(String scmPrivateKey) {
        this.releaseDescriptor.setScmPrivateKey(scmPrivateKey);
        return this;
    }

    public ReleaseDescriptorBuilder setScmPrivateKeyPassPhrase(String scmPrivateKeyPassPhrase) {
        this.releaseDescriptor.setScmPrivateKeyPassPhrase(scmPrivateKeyPassPhrase);
        return this;
    }

    public ReleaseDescriptorBuilder setScmRelativePathProjectDirectory(String scmRelativePathProjectDirectory) {
        this.releaseDescriptor.setScmRelativePathProjectDirectory(scmRelativePathProjectDirectory);
        return this;
    }

    public ReleaseDescriptorBuilder setScmReleaseLabel(String scmReleaseLabel) {
        this.releaseDescriptor.setScmReleaseLabel(scmReleaseLabel);
        return this;
    }

    public ReleaseDescriptorBuilder setScmReleasedPomRevision(String scmReleasedPomRevision) {
        this.releaseDescriptor.setScmReleasedPomRevision(scmReleasedPomRevision);
        return this;
    }

    public ReleaseDescriptorBuilder setScmSourceUrl(String scmSourceUrl) {
        this.releaseDescriptor.setScmSourceUrl(scmSourceUrl);
        return this;
    }

    public ReleaseDescriptorBuilder setScmTagBase(String scmTagBase) {
        this.releaseDescriptor.setScmTagBase(scmTagBase);
        return this;
    }

    public ReleaseDescriptorBuilder setScmTagNameFormat(String scmTagNameFormat) {
        this.releaseDescriptor.setScmTagNameFormat(scmTagNameFormat);
        return this;
    }

    public ReleaseDescriptorBuilder setScmSignTags(boolean signTags) {
        this.releaseDescriptor.setScmSignTags(signTags);
        return this;
    }

    public ReleaseDescriptorBuilder setScmUseEditMode(boolean scmUseEditMode) {
        this.releaseDescriptor.setScmUseEditMode(scmUseEditMode);
        return this;
    }

    public ReleaseDescriptorBuilder setScmUsername(String scmUsername) {
        this.releaseDescriptor.setScmUsername(scmUsername);
        return this;
    }

    public ReleaseDescriptorBuilder setSnapshotReleasePluginAllowed(boolean snapshotReleasePluginAllowed) {
        this.releaseDescriptor.setSnapshotReleasePluginAllowed(snapshotReleasePluginAllowed);
        return this;
    }

    public ReleaseDescriptorBuilder setSuppressCommitBeforeTagOrBranch(boolean suppressCommitBeforeTagOrBranch) {
        this.releaseDescriptor.setSuppressCommitBeforeTagOrBranch(suppressCommitBeforeTagOrBranch);
        return this;
    }

    public ReleaseDescriptorBuilder setUpdateBranchVersions(boolean updateBranchVersions) {
        this.releaseDescriptor.setUpdateBranchVersions(updateBranchVersions);
        return this;
    }

    public ReleaseDescriptorBuilder setUpdateDependencies(boolean updateDependencies) {
        this.releaseDescriptor.setUpdateDependencies(updateDependencies);
        return this;
    }

    public ReleaseDescriptorBuilder setUpdateVersionsToSnapshot(boolean updateVersionsToSnapshot) {
        this.releaseDescriptor.setUpdateVersionsToSnapshot(updateVersionsToSnapshot);
        return this;
    }

    public ReleaseDescriptorBuilder setUpdateWorkingCopyVersions(boolean updateWorkingCopyVersions) {
        this.releaseDescriptor.setUpdateWorkingCopyVersions(updateWorkingCopyVersions);
        return this;
    }

    public ReleaseDescriptorBuilder setUseReleaseProfile(boolean useReleaseProfile) {
        this.releaseDescriptor.setUseReleaseProfile(useReleaseProfile);
        return this;
    }

    public ReleaseDescriptorBuilder setWaitBeforeTagging(int waitBeforeTagging) {
        this.releaseDescriptor.setWaitBeforeTagging(waitBeforeTagging);
        return this;
    }

    public ReleaseDescriptorBuilder setWorkingDirectory(String workingDirectory) {
        this.releaseDescriptor.setWorkingDirectory(workingDirectory);
        return this;
    }

    public ReleaseDescriptorBuilder addReleaseVersion(String key, String value) {
        this.releaseDescriptor.addReleaseVersion(key, value);
        return this;
    }

    public ReleaseDescriptorBuilder addDevelopmentVersion(String key, String value) {
        this.releaseDescriptor.addDevelopmentVersion(key, value);
        return this;
    }

    public ReleaseDescriptorBuilder addOriginalScmInfo(String key, Scm value) {
        this.releaseDescriptor.addOriginalScmInfo(key, value);
        return this;
    }

    public void putOriginalVersion(String projectKey, String version) {
        this.releaseDescriptor.addOriginalVersion(projectKey, version);
    }

    public ReleaseDescriptorBuilder addDependencyOriginalVersion(String dependencyKey, String version) {
        this.releaseDescriptor.addDependencyOriginalVersion(dependencyKey, version);
        return this;
    }

    public ReleaseDescriptorBuilder addDependencyReleaseVersion(String dependencyKey, String version) {
        this.releaseDescriptor.addDependencyReleaseVersion(dependencyKey, version);
        return this;
    }

    public ReleaseDescriptorBuilder addDependencyDevelopmentVersion(String dependencyKey, String version) {
        this.releaseDescriptor.addDependencyDevelopmentVersion(dependencyKey, version);
        return this;
    }

    public ReleaseDescriptorBuilder setAutoResolveSnapshots(String autoResolveSnapshots) {
        this.releaseDescriptor.setAutoResolveSnapshots(autoResolveSnapshots);
        return this;
    }

    public ReleaseDescriptorBuilder setPinExternals(boolean pinExternals) {
        this.releaseDescriptor.setPinExternals(pinExternals);
        return this;
    }

    public BuilderReleaseDescriptor build() {
        return this.releaseDescriptor;
    }

    public static final class BuilderReleaseDescriptor
    extends ModelloReleaseDescriptor
    implements ReleaseDescriptor {
        private BuilderReleaseDescriptor() {
        }
    }
}

