/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.superpom.SuperPomProvider;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePomsPhase;
import org.apache.maven.shared.release.phase.ReleasePhase;
import org.apache.maven.shared.release.phase.ResourceGenerator;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ScmTranslator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

@Component(role=ReleasePhase.class, hint="generate-release-poms")
public class GenerateReleasePomsPhase
extends AbstractReleasePomsPhase
implements ResourceGenerator {
    private static final String FINALNAME_EXPRESSION = "${project.artifactId}-${project.version}";
    @Requirement
    private SuperPomProvider superPomProvider;
    @Requirement
    private ModelInterpolator modelInterpolator;
    @Requirement(role=ScmTranslator.class)
    private Map<String, ScmTranslator> scmTranslators;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment, reactorProjects, false);
    }

    private ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean simulate) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        if (releaseDescriptor.isGenerateReleasePoms()) {
            this.logInfo(result, "Generating release POMs...");
            this.generateReleasePoms(releaseDescriptor, releaseEnvironment, reactorProjects, simulate, result);
        } else {
            this.logInfo(result, "Not generating release POMs");
        }
        result.setResultCode(0);
        return result;
    }

    private void generateReleasePoms(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean simulate, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        ArrayList<File> releasePoms = new ArrayList<File>();
        for (MavenProject project : reactorProjects) {
            this.logInfo(result, "Generating release POM for '" + project.getName() + "'...");
            releasePoms.add(this.generateReleasePom(project, releaseDescriptor, releaseEnvironment, result));
        }
        this.addReleasePomsToScm(releaseDescriptor, releaseEnvironment, reactorProjects, simulate, result, releasePoms);
    }

    private File generateReleasePom(MavenProject project, ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        Model releasePom = this.createReleaseModel(project, releaseDescriptor, releaseEnvironment, result);
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        File releasePomFile = ReleaseUtil.getReleasePom(project);
        if (releasePomFile == null) {
            throw new ReleaseExecutionException("Cannot generate release POM : pom file is null");
        }
        try (XmlStreamWriter fileWriter = WriterFactory.newXmlWriter((File)releasePomFile);){
            pomWriter.write((Writer)fileWriter, releasePom);
        }
        catch (IOException exception) {
            throw new ReleaseExecutionException("Cannot generate release POM", (Throwable)exception);
        }
        return releasePomFile;
    }

    private void addReleasePomsToScm(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean simulate, ReleaseResult result, List<File> releasePoms) throws ReleaseFailureException, ReleaseExecutionException {
        if (simulate) {
            this.logInfo(result, "Full run would be adding " + releasePoms);
        } else {
            ScmRepository scmRepository = this.getScmRepository(releaseDescriptor, releaseEnvironment);
            ScmProvider scmProvider = this.getScmProvider(scmRepository);
            MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
            ScmFileSet scmFileSet = new ScmFileSet(rootProject.getFile().getParentFile(), releasePoms);
            try {
                AddScmResult scmResult = scmProvider.add(scmRepository, scmFileSet);
                if (!scmResult.isSuccess()) {
                    throw new ReleaseScmCommandException("Cannot add release POM to SCM", (ScmResult)scmResult);
                }
            }
            catch (ScmException exception) {
                throw new ReleaseExecutionException("Cannot add release POM to SCM: " + exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private Model createReleaseModel(MavenProject project, ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, ReleaseResult result) throws ReleaseFailureException, ReleaseExecutionException {
        String finalName;
        MavenProject releaseProject = project.clone();
        Model releaseModel = releaseProject.getModel();
        releaseModel.setParent(null);
        releaseModel.setProfiles(Collections.emptyList());
        releaseModel.setDependencyManagement(null);
        releaseProject.getBuild().setPluginManagement(null);
        String projectVersion = releaseModel.getVersion();
        String releaseVersion = this.getNextVersion(releaseDescriptor, project.getGroupId(), project.getArtifactId());
        releaseModel.setVersion(releaseVersion);
        String originalFinalName = releaseModel.getBuild().getFinalName();
        if (!FINALNAME_EXPRESSION.equals(originalFinalName) && (originalFinalName = this.findOriginalFinalName(project)) == null) {
            originalFinalName = FINALNAME_EXPRESSION;
        }
        if ((finalName = ReleaseUtil.interpolate(originalFinalName, releaseModel)).indexOf("SNAPSHOT") != -1) {
            throw new ReleaseFailureException("Cannot reliably adjust the finalName of project: " + releaseProject.getId());
        }
        releaseModel.getBuild().setFinalName(finalName);
        Scm scm = releaseModel.getScm();
        if (scm != null) {
            ScmRepository scmRepository = this.getScmRepository(releaseDescriptor, releaseEnvironment);
            ScmTranslator scmTranslator = this.getScmTranslator(scmRepository);
            if (scmTranslator != null) {
                releaseModel.setScm(this.createReleaseScm(releaseModel.getScm(), scmTranslator, releaseDescriptor));
            } else {
                String message = "No SCM translator found - skipping rewrite";
                result.appendDebug(message);
                this.getLogger().debug(message);
            }
        }
        releaseModel.setDependencies(this.createReleaseDependencies(releaseDescriptor, releaseProject));
        releaseModel.getBuild().setPlugins(this.createReleasePlugins(releaseDescriptor, releaseProject));
        releaseModel.getReporting().setPlugins(this.createReleaseReportPlugins(releaseDescriptor, releaseProject));
        releaseModel.getBuild().setExtensions(this.createReleaseExtensions(releaseDescriptor, releaseProject));
        this.unalignFromBaseDirectory(releaseModel, project.getBasedir());
        return releaseModel;
    }

    private void unalignFromBaseDirectory(Model releaseModel, File basedir) {
        int i;
        LinkedHashMap<String, String> superResourceDirectories;
        Model rawSuperModel = this.superPomProvider.getSuperModel(releaseModel.getModelVersion());
        DefaultModelBuildingRequest buildingRequest = new DefaultModelBuildingRequest();
        buildingRequest.setValidationLevel(30);
        Properties properties = new Properties();
        properties.put("project.version", releaseModel.getVersion());
        properties.put("project.artifactId", releaseModel.getArtifactId());
        buildingRequest.setUserProperties(properties);
        Model interpolatedSuperModel = this.modelInterpolator.interpolateModel(rawSuperModel.clone(), basedir, (ModelBuildingRequest)buildingRequest, null);
        Build currentBuild = releaseModel.getBuild();
        Build interpolatedSuperBuild = interpolatedSuperModel.getBuild();
        Build rawSuperBuild = rawSuperModel.getBuild();
        currentBuild.setSourceDirectory(this.resolvePath(basedir.toPath(), currentBuild.getSourceDirectory(), interpolatedSuperBuild.getSourceDirectory(), rawSuperBuild.getSourceDirectory()));
        currentBuild.setScriptSourceDirectory(this.resolvePath(basedir.toPath(), currentBuild.getScriptSourceDirectory(), interpolatedSuperBuild.getScriptSourceDirectory(), rawSuperBuild.getScriptSourceDirectory()));
        currentBuild.setTestSourceDirectory(this.resolvePath(basedir.toPath(), currentBuild.getTestSourceDirectory(), interpolatedSuperBuild.getTestSourceDirectory(), rawSuperBuild.getTestSourceDirectory()));
        currentBuild.setOutputDirectory(this.resolvePath(basedir.toPath(), currentBuild.getOutputDirectory(), interpolatedSuperBuild.getOutputDirectory(), rawSuperBuild.getOutputDirectory()));
        currentBuild.setTestOutputDirectory(this.resolvePath(basedir.toPath(), currentBuild.getTestOutputDirectory(), interpolatedSuperBuild.getTestOutputDirectory(), rawSuperBuild.getTestOutputDirectory()));
        currentBuild.setDirectory(this.resolvePath(basedir.toPath(), currentBuild.getDirectory(), interpolatedSuperBuild.getDirectory(), rawSuperBuild.getDirectory()));
        for (Resource currentResource : currentBuild.getResources()) {
            superResourceDirectories = new LinkedHashMap<String, String>(interpolatedSuperBuild.getResources().size());
            for (i = 0; i < interpolatedSuperBuild.getResources().size(); ++i) {
                superResourceDirectories.put(((Resource)interpolatedSuperBuild.getResources().get(i)).getDirectory(), ((Resource)rawSuperBuild.getResources().get(i)).getDirectory());
            }
            currentResource.setDirectory(this.resolvePath(basedir.toPath(), currentResource.getDirectory(), superResourceDirectories));
        }
        for (Resource currentResource : currentBuild.getTestResources()) {
            superResourceDirectories = new LinkedHashMap(interpolatedSuperBuild.getTestResources().size());
            for (i = 0; i < interpolatedSuperBuild.getTestResources().size(); ++i) {
                superResourceDirectories.put(((Resource)interpolatedSuperBuild.getTestResources().get(i)).getDirectory(), ((Resource)rawSuperBuild.getTestResources().get(i)).getDirectory());
            }
            currentResource.setDirectory(this.resolvePath(basedir.toPath(), currentResource.getDirectory(), superResourceDirectories));
        }
        releaseModel.getReporting().setOutputDirectory(this.resolvePath(basedir.toPath(), releaseModel.getReporting().getOutputDirectory(), interpolatedSuperModel.getReporting().getOutputDirectory(), rawSuperModel.getReporting().getOutputDirectory()));
    }

    private String resolvePath(Path basedir, String current, String superInterpolated, String superRaw) {
        return basedir.resolve(current).equals(basedir.resolve(superInterpolated)) ? superRaw : current;
    }

    private String resolvePath(Path basedir, String current, Map<String, String> superValues) {
        for (Map.Entry<String, String> superValue : superValues.entrySet()) {
            if (!basedir.resolve(current).equals(basedir.resolve(superValue.getKey()))) continue;
            return superValue.getValue();
        }
        return current;
    }

    private String findOriginalFinalName(MavenProject project) {
        if (project.getOriginalModel().getBuild() != null && project.getOriginalModel().getBuild().getFinalName() != null) {
            return project.getOriginalModel().getBuild().getFinalName();
        }
        if (project.hasParent()) {
            return this.findOriginalFinalName(project.getParent());
        }
        return null;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment, reactorProjects, true);
    }

    private String getNextVersion(ReleaseDescriptor releaseDescriptor, String groupId, String artifactId) throws ReleaseFailureException {
        String id = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
        String nextVersion = releaseDescriptor.getProjectReleaseVersion(id);
        if (nextVersion == null) {
            throw new ReleaseFailureException("Version for '" + id + "' was not mapped");
        }
        return nextVersion;
    }

    private ScmTranslator getScmTranslator(ScmRepository scmRepository) {
        return this.scmTranslators.get(scmRepository.getProvider());
    }

    private Scm createReleaseScm(Scm scm, ScmTranslator scmTranslator, ReleaseDescriptor releaseDescriptor) {
        String value;
        String tag = releaseDescriptor.getScmReleaseLabel();
        String tagBase = releaseDescriptor.getScmTagBase();
        Scm releaseScm = new Scm();
        if (scm.getConnection() != null) {
            value = scmTranslator.translateTagUrl(scm.getConnection(), tag, tagBase);
            releaseScm.setConnection(value);
        }
        if (scm.getDeveloperConnection() != null) {
            value = scmTranslator.translateTagUrl(scm.getDeveloperConnection(), tag, tagBase);
            releaseScm.setDeveloperConnection(value);
        }
        if (scm.getUrl() != null) {
            value = scmTranslator.translateTagUrl(scm.getUrl(), tag, tagBase);
            releaseScm.setUrl(value);
        }
        if (scm.getTag() != null) {
            value = scmTranslator.resolveTag(scm.getTag());
            releaseScm.setTag(value);
        }
        return releaseScm;
    }

    private List<Dependency> createReleaseDependencies(ReleaseDescriptor releaseDescriptor, MavenProject project) throws ReleaseFailureException {
        Set artifacts = project.getArtifacts();
        ArrayList<Dependency> releaseDependencies = null;
        if (artifacts != null) {
            ArrayList orderedArtifacts = new ArrayList();
            orderedArtifacts.addAll(artifacts);
            Collections.sort(orderedArtifacts);
            releaseDependencies = new ArrayList<Dependency>();
            for (Artifact artifact : orderedArtifacts) {
                Dependency releaseDependency = new Dependency();
                releaseDependency.setGroupId(artifact.getGroupId());
                releaseDependency.setArtifactId(artifact.getArtifactId());
                String version = this.getReleaseVersion(releaseDescriptor, artifact);
                releaseDependency.setVersion(version);
                releaseDependency.setType(artifact.getType());
                releaseDependency.setScope(artifact.getScope());
                releaseDependency.setClassifier(artifact.getClassifier());
                releaseDependencies.add(releaseDependency);
            }
        }
        return releaseDependencies;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getReleaseVersion(ReleaseDescriptor releaseDescriptor, Artifact artifact) throws ReleaseFailureException {
        String key = ArtifactUtils.versionlessKey((Artifact)artifact);
        String originalVersion = releaseDescriptor.getProjectOriginalVersion(key);
        String mappedVersion = releaseDescriptor.getProjectReleaseVersion(key);
        String version = artifact.getVersion();
        if (version.equals(originalVersion)) {
            if (mappedVersion == null) throw new ReleaseFailureException("Version '" + version + "' for '" + key + "' was not mapped");
            return mappedVersion;
        }
        if (ArtifactUtils.isSnapshot((String)version)) return version;
        return artifact.getBaseVersion();
    }

    private List<Plugin> createReleasePlugins(ReleaseDescriptor releaseDescriptor, MavenProject project) throws ReleaseFailureException {
        List plugins;
        ArrayList<Plugin> releasePlugins = null;
        Build build = project.getOriginalModel().getBuild();
        if (build != null && (plugins = build.getPlugins()) != null) {
            Map artifactsById = project.getPluginArtifactMap();
            releasePlugins = new ArrayList<Plugin>();
            for (Plugin plugin : plugins) {
                String id = ArtifactUtils.versionlessKey((String)plugin.getGroupId(), (String)plugin.getArtifactId());
                Artifact artifact = (Artifact)artifactsById.get(id);
                String version = this.getReleaseVersion(releaseDescriptor, artifact);
                Plugin releasePlugin = new Plugin();
                releasePlugin.setGroupId(plugin.getGroupId());
                releasePlugin.setArtifactId(plugin.getArtifactId());
                releasePlugin.setVersion(version);
                if (plugin.getExtensions() != null) {
                    releasePlugin.setExtensions(plugin.isExtensions());
                }
                releasePlugin.setExecutions(plugin.getExecutions());
                releasePlugin.setDependencies(plugin.getDependencies());
                releasePlugin.setGoals(plugin.getGoals());
                releasePlugin.setInherited(plugin.getInherited());
                releasePlugin.setConfiguration(plugin.getConfiguration());
                releasePlugins.add(releasePlugin);
            }
        }
        return releasePlugins;
    }

    private List<ReportPlugin> createReleaseReportPlugins(ReleaseDescriptor releaseDescriptor, MavenProject project) throws ReleaseFailureException {
        List reportPlugins;
        ArrayList<ReportPlugin> releaseReportPlugins = null;
        Reporting reporting = project.getModel().getReporting();
        if (reporting != null && (reportPlugins = reporting.getPlugins()) != null) {
            Map artifactsById = project.getReportArtifactMap();
            releaseReportPlugins = new ArrayList<ReportPlugin>();
            for (ReportPlugin reportPlugin : reportPlugins) {
                String id = ArtifactUtils.versionlessKey((String)reportPlugin.getGroupId(), (String)reportPlugin.getArtifactId());
                Artifact artifact = (Artifact)artifactsById.get(id);
                String version = this.getReleaseVersion(releaseDescriptor, artifact);
                ReportPlugin releaseReportPlugin = new ReportPlugin();
                releaseReportPlugin.setGroupId(reportPlugin.getGroupId());
                releaseReportPlugin.setArtifactId(reportPlugin.getArtifactId());
                releaseReportPlugin.setVersion(version);
                releaseReportPlugin.setInherited(reportPlugin.getInherited());
                releaseReportPlugin.setConfiguration(reportPlugin.getConfiguration());
                releaseReportPlugin.setReportSets(reportPlugin.getReportSets());
                releaseReportPlugins.add(releaseReportPlugin);
            }
        }
        return releaseReportPlugins;
    }

    private List<Extension> createReleaseExtensions(ReleaseDescriptor releaseDescriptor, MavenProject project) throws ReleaseFailureException {
        List extensions;
        ArrayList<Extension> releaseExtensions = null;
        Build build = project.getOriginalModel().getBuild();
        if (build != null && (extensions = build.getExtensions()) != null) {
            releaseExtensions = new ArrayList<Extension>();
            for (Extension extension : extensions) {
                String id = ArtifactUtils.versionlessKey((String)extension.getGroupId(), (String)extension.getArtifactId());
                Artifact artifact = (Artifact)project.getExtensionArtifactMap().get(id);
                String version = this.getReleaseVersion(releaseDescriptor, artifact);
                Extension releaseExtension = new Extension();
                releaseExtension.setGroupId(extension.getGroupId());
                releaseExtension.setArtifactId(extension.getArtifactId());
                releaseExtension.setVersion(version);
                releaseExtensions.add(releaseExtension);
            }
        }
        return releaseExtensions;
    }

    public ReleaseResult clean(List<MavenProject> reactorProjects) {
        ReleaseResult result = new ReleaseResult();
        for (MavenProject project : reactorProjects) {
            File releasePom = ReleaseUtil.getReleasePom(project);
            if (releasePom == null || !releasePom.exists()) continue;
            this.logInfo(result, "Deleting release POM for '" + project.getName() + "'...");
            if (releasePom.delete()) continue;
            this.logWarn(result, "Cannot delete release POM: " + releasePom);
        }
        result.setResultCode(0);
        return result;
    }
}

