/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.transform.jdom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.shared.release.transform.jdom.JDomBuild;
import org.apache.maven.shared.release.transform.jdom.JDomDependency;
import org.apache.maven.shared.release.transform.jdom.JDomDependencyManagement;
import org.jdom.Element;

public class JDomModelBase {
    private final Element modelBase;

    public JDomModelBase(Element modelBase) {
        this.modelBase = modelBase;
    }

    public Build getBuild() {
        Element elm = this.modelBase.getChild("build", this.modelBase.getNamespace());
        if (elm == null) {
            return null;
        }
        return new JDomBuild(elm);
    }

    public List<Dependency> getDependencies() {
        Element dependenciesElm = this.modelBase.getChild("dependencies", this.modelBase.getNamespace());
        if (dependenciesElm == null) {
            return Collections.emptyList();
        }
        List dependencyElms = dependenciesElm.getChildren("dependency", this.modelBase.getNamespace());
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(dependencyElms.size());
        for (Element dependencyElm : dependencyElms) {
            dependencies.add(new JDomDependency(dependencyElm));
        }
        return dependencies;
    }

    public DependencyManagement getDependencyManagement() {
        Element elm = this.modelBase.getChild("dependencyManagement", this.modelBase.getNamespace());
        if (elm == null) {
            return null;
        }
        return new JDomDependencyManagement(elm);
    }
}

