/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractScmCommitPhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;

public class ScmCommitDevelopmentPhase
extends AbstractScmCommitPhase {
    private String rollbackMessageFormat;

    @Override
    protected void runLogic(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, ReleaseResult result, boolean simulating) throws ReleaseScmCommandException, ReleaseExecutionException, ReleaseScmRepositoryException {
        if (releaseDescriptor.isSuppressCommitBeforeTagOrBranch() && !releaseDescriptor.isUpdateWorkingCopyVersions()) {
            if (simulating) {
                this.logInfo(result, "Full run would not commit changes, because updateWorkingCopyVersions is false.");
            } else {
                this.logInfo(result, "Modified POMs are not committed because updateWorkingCopyVersions is set to false.");
            }
        } else {
            String message = !releaseDescriptor.isUpdateWorkingCopyVersions() ? this.createRollbackMessage(releaseDescriptor) : this.createMessage(releaseDescriptor);
            if (simulating) {
                List<File> pomFiles = ScmCommitDevelopmentPhase.createPomFiles(releaseDescriptor, reactorProjects);
                this.logInfo(result, "Full run would be commit " + pomFiles.size() + " files with message: '" + message + "'");
            } else {
                this.performCheckins(releaseDescriptor, releaseEnvironment, reactorProjects, message);
            }
        }
    }

    private String createRollbackMessage(ReleaseDescriptor releaseDescriptor) {
        return MessageFormat.format(releaseDescriptor.getScmCommentPrefix() + this.rollbackMessageFormat, releaseDescriptor.getScmReleaseLabel());
    }
}

