/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.exec;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.exec.AbstractMavenExecutor;
import org.apache.maven.shared.release.exec.CommandLineFactory;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.apache.maven.shared.release.exec.RawStreamPumper;
import org.apache.maven.shared.release.exec.TeeOutputStream;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkedMavenExecutor
extends AbstractMavenExecutor {
    private CommandLineFactory commandLineFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeGoals(File workingDirectory, List<String> goals, ReleaseEnvironment releaseEnvironment, boolean interactive, String additionalArguments, String pomFileName, ReleaseResult relResult) throws MavenExecutorException {
        String mavenPath = null;
        mavenPath = releaseEnvironment.getMavenHome() != null ? releaseEnvironment.getMavenHome().getAbsolutePath() : System.getProperty("maven.home");
        File settingsFile = null;
        if (releaseEnvironment.getSettings() != null) {
            try {
                settingsFile = File.createTempFile("release-settings", ".xml");
                SettingsXpp3Writer writer = this.getSettingsWriter();
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(settingsFile);
                    writer.write((Writer)fileWriter, this.encryptSettings(releaseEnvironment.getSettings()));
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileWriter);
                    throw throwable;
                }
                IOUtil.close((Writer)fileWriter);
            }
            catch (IOException e) {
                throw new MavenExecutorException("Could not create temporary file for release settings.xml", e);
            }
        }
        try {
            Commandline cl = this.commandLineFactory.createCommandLine(mavenPath + File.separator + "bin" + File.separator + "mvn");
            cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
            cl.addEnvironment("MAVEN_TERMINATE_CMD", "on");
            cl.addEnvironment("M2_HOME", mavenPath);
            if (settingsFile != null) {
                cl.createArg().setValue("-s");
                cl.createArg().setFile(settingsFile);
            }
            if (pomFileName != null) {
                cl.createArg().setValue("-f");
                cl.createArg().setValue(pomFileName);
            }
            for (String goal : goals) {
                cl.createArg().setValue(goal);
            }
            cl.createArg().setValue("--no-plugin-updates");
            if (!interactive) {
                cl.createArg().setValue("--batch-mode");
            }
            if (!StringUtils.isEmpty((String)additionalArguments)) {
                cl.createArg().setLine(additionalArguments);
            }
            TeeOutputStream stdOut = new TeeOutputStream(System.out);
            TeeOutputStream stdErr = new TeeOutputStream(System.err);
            try {
                relResult.appendInfo("Executing: " + cl.toString());
                this.getLogger().info("Executing: " + cl.toString());
                int result = ForkedMavenExecutor.executeCommandLine(cl, System.in, stdOut, stdErr);
                if (result != 0) {
                    throw new MavenExecutorException("Maven execution failed, exit code: '" + result + "'", result, stdOut.toString(), stdErr.toString());
                }
            }
            catch (CommandLineException e) {
                throw new MavenExecutorException("Can't run goal " + goals, stdOut.toString(), stdErr.toString(), (Exception)((Object)e));
            }
            finally {
                relResult.appendOutput(stdOut.toString());
            }
        }
        finally {
            if (settingsFile != null && settingsFile.exists() && !settingsFile.delete()) {
                settingsFile.deleteOnExit();
            }
        }
    }

    public void setCommandLineFactory(CommandLineFactory commandLineFactory) {
        this.commandLineFactory = commandLineFactory;
    }

    public static int executeCommandLine(Commandline cl, InputStream systemIn, OutputStream systemOut, OutputStream systemErr) throws CommandLineException {
        if (cl == null) {
            throw new IllegalArgumentException("cl cannot be null.");
        }
        Process p = cl.execute();
        RawStreamPumper inputFeeder = null;
        if (systemIn != null) {
            inputFeeder = new RawStreamPumper(systemIn, p.getOutputStream(), true);
        }
        RawStreamPumper outputPumper = new RawStreamPumper(p.getInputStream(), systemOut);
        RawStreamPumper errorPumper = new RawStreamPumper(p.getErrorStream(), systemErr);
        if (inputFeeder != null) {
            inputFeeder.start();
        }
        outputPumper.start();
        errorPumper.start();
        try {
            int returnValue = p.waitFor();
            if (inputFeeder != null) {
                inputFeeder.setDone();
            }
            outputPumper.setDone();
            errorPumper.setDone();
            int n = returnValue;
            return n;
        }
        catch (InterruptedException ex) {
            throw new CommandLineException("Error while executing external command, process killed.", (Throwable)ex);
        }
        finally {
            try {
                errorPumper.closeInput();
            }
            catch (IOException e) {}
            try {
                outputPumper.closeInput();
            }
            catch (IOException e) {}
            if (inputFeeder != null) {
                try {
                    inputFeeder.closeOutput();
                }
                catch (IOException e) {}
            }
        }
    }
}

