/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.repository;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.components.interactivity.InputHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BundleUtils {
    private BundleUtils() {
    }

    public static List<File> selectProjectFiles(File dir, InputHandler inputHandler, final String finalName, File pom, Log log, boolean batchMode) throws MojoExecutionException {
        File[] projectFiles = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return new File(dir, name).isFile() && name.startsWith(finalName);
            }
        });
        List<File> result = new ArrayList<File>();
        if (projectFiles == null) {
            return result;
        }
        for (int i = 0; i < projectFiles.length; ++i) {
            if (projectFiles[i].getName().endsWith(".pom")) {
                if (projectFiles[i].equals(pom)) continue;
                log.info((CharSequence)("Detected POM file will be excluded:\n" + projectFiles[i] + "\n\nInstead, the bundle will include the POM from:\n" + pom));
                continue;
            }
            if (projectFiles[i].getName().endsWith("-bundle.jar")) {
                log.warn((CharSequence)("Skipping project file which collides with repository bundle filename:\n" + projectFiles[i]));
                continue;
            }
            result.add(projectFiles[i]);
        }
        if (result.isEmpty()) {
            return result;
        }
        Collections.sort(result, new Comparator<File>(){

            @Override
            public int compare(File first, File second) {
                String f = first.getName();
                String s = second.getName();
                if (f.length() == s.length()) {
                    return f.compareTo(s);
                }
                return f.length() < s.length() ? -1 : 1;
            }
        });
        result = BundleUtils.reviseFileList(result, inputHandler, log, batchMode);
        return result;
    }

    public static List<File> reviseFileList(List<File> input, InputHandler inputHandler, Log log, boolean batchMode) throws MojoExecutionException {
        ArrayList<File> result = new ArrayList<File>(input);
        if (batchMode) {
            return result;
        }
        block2: while (true) {
            StringTokenizer st;
            StringBuffer message = new StringBuffer();
            message.append("The following files are marked for inclusion in the repository bundle:\n");
            message.append("\n0.) Done");
            int i = 1;
            for (File f : result) {
                message.append("\n").append(i++).append(".) ").append(f.getName());
            }
            message.append("\n\nPlease select the number(s) for any files you wish to exclude, or '0' when you're done.\nSeparate the numbers for multiple files with a comma (',').\n\nSelection: ");
            log.info((CharSequence)message);
            String response = null;
            try {
                response = inputHandler.readLine();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Project file selection failed with an I/O exception: " + e.getMessage(), (Exception)e);
            }
            if (response == null || "0".equals(response) || (st = new StringTokenizer(response, ",")).countTokens() <= 0) break;
            int[] idxs = new int[st.countTokens()];
            for (int j = 0; j < idxs.length; ++j) {
                idxs[j] = Integer.parseInt(st.nextToken().trim());
            }
            Arrays.sort(idxs);
            int k = idxs.length - 1;
            while (true) {
                if (k <= -1) continue block2;
                if (idxs[k] < 1 || idxs[k] > result.size()) {
                    log.warn((CharSequence)("NOT removing: " + idxs[k] + "; no such file."));
                } else {
                    File removed = (File)result.remove(idxs[k] - 1);
                    log.info((CharSequence)("Removed: " + removed.getName()));
                }
                --k;
            }
            break;
        }
        return result;
    }
}

