/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Locale;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.dependencies.ManagementDependencies;
import org.apache.maven.report.projectinfo.dependencies.RepositoryUtils;
import org.apache.maven.report.projectinfo.dependencies.renderer.DependencyManagementRenderer;

@Mojo(name="dependency-management", requiresDependencyResolution=ResolutionScope.TEST)
public class DependencyManagementReport
extends AbstractProjectInfoReport {
    @Component
    protected ArtifactMetadataSource artifactMetadataSource;
    @Component
    private RepositoryMetadataManager repositoryMetadataManager;
    private ManagementDependencies managementDependencies;

    @Override
    public boolean canGenerateReport() {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            result = this.getManagementDependencies().hasDependencies();
        }
        return result;
    }

    public void executeReport(Locale locale) {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.getSession().getProjectBuildingRequest());
        buildingRequest.setLocalRepository(this.localRepository);
        buildingRequest.setRemoteRepositories(this.remoteRepositories);
        buildingRequest.setPluginArtifactRepositories(this.pluginRepositories);
        RepositoryUtils repoUtils = new RepositoryUtils(this.getLog(), this.projectBuilder, this.repositorySystem, this.resolver, this.project.getRemoteArtifactRepositories(), this.project.getPluginArtifactRepositories(), (ProjectBuildingRequest)buildingRequest, this.repositoryMetadataManager);
        DependencyManagementRenderer r = new DependencyManagementRenderer(this.getSink(), locale, this.getI18N(locale), this.getLog(), this.getManagementDependencies(), this.artifactMetadataSource, this.repositorySystem, this.projectBuilder, (ProjectBuildingRequest)buildingRequest, repoUtils);
        r.render();
    }

    public String getOutputName() {
        return "dependency-management";
    }

    @Override
    protected String getI18Nsection() {
        return "dependency-management";
    }

    private ManagementDependencies getManagementDependencies() {
        if (this.managementDependencies != null) {
            return this.managementDependencies;
        }
        this.managementDependencies = this.project.getDependencyManagement() == null ? new ManagementDependencies(null) : new ManagementDependencies(this.project.getDependencyManagement().getDependencies());
        return this.managementDependencies;
    }
}

