/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.ProjectInfoReportUtils;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;
import org.joda.time.DateTimeZone;

@Mojo(name="project-team")
public class TeamListReport
extends AbstractProjectInfoReport {
    @Parameter(property="teamlist.showAvatarImages", defaultValue="true")
    private boolean showAvatarImages;

    public void executeReport(Locale locale) {
        TeamListRenderer r = new TeamListRenderer(this.getSink(), this.project.getModel(), this.getI18N(locale), locale, this.getLog(), this.showAvatarImages);
        r.render();
    }

    public String getOutputName() {
        return "team-list";
    }

    protected String getI18Nsection() {
        return "team-list";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TeamListRenderer
    extends AbstractProjectInfoRenderer {
        private static final String PROPERTIES = "properties";
        private static final String TIME_ZONE = "timeZone";
        private static final String ROLES = "roles";
        private static final String ORGANIZATION_URL = "organizationUrl";
        private static final String ORGANIZATION = "organization";
        private static final String URL = "url";
        private static final String EMAIL = "email";
        private static final String NAME = "name";
        private static final String IMAGE = "image";
        private static final String ID = "id";
        private final Model model;
        private final Log log;
        private final boolean showAvatarImages;
        private static final String[] EMPTY_STRING_ARRAY = new String[0];
        private static final String avatar_size = "s=60";

        TeamListRenderer(Sink sink, Model model, I18N i18n, Locale locale, Log log, boolean showAvatarImages) {
            super(sink, i18n, locale);
            this.model = model;
            this.log = log;
            this.showAvatarImages = showAvatarImages;
        }

        @Override
        protected String getI18Nsection() {
            return "team-list";
        }

        public void renderBody() {
            this.startSection(this.getI18nString("intro.title"));
            StringBuilder javascript = new StringBuilder("function offsetDate(id, offset) {").append(SystemUtils.LINE_SEPARATOR);
            javascript.append("    var now = new Date();").append(SystemUtils.LINE_SEPARATOR);
            javascript.append("    var nowTime = now.getTime();").append(SystemUtils.LINE_SEPARATOR);
            javascript.append("    var localOffset = now.getTimezoneOffset();").append(SystemUtils.LINE_SEPARATOR);
            javascript.append("    var developerTime = nowTime + ( offset * 60 * 60 * 1000 )+ ( localOffset * 60 * 1000 );").append(SystemUtils.LINE_SEPARATOR);
            javascript.append("    var developerDate = new Date(developerTime);").append(SystemUtils.LINE_SEPARATOR);
            javascript.append(SystemUtils.LINE_SEPARATOR);
            javascript.append("    document.getElementById(id).innerHTML = developerDate;").append(SystemUtils.LINE_SEPARATOR);
            javascript.append("}").append(SystemUtils.LINE_SEPARATOR);
            javascript.append(SystemUtils.LINE_SEPARATOR);
            javascript.append("function init(){").append(SystemUtils.LINE_SEPARATOR);
            this.paragraph(this.getI18nString("intro.description1"));
            this.paragraph(this.getI18nString("intro.description2"));
            List developers = this.model.getDevelopers();
            this.startSection(this.getI18nString("developers.title"));
            if (this.isEmpty(developers)) {
                this.paragraph(this.getI18nString("nodeveloper"));
            } else {
                this.paragraph(this.getI18nString("developers.intro"));
                this.startTable();
                Map<String, Boolean> headersMap = this.checkRequiredHeaders(developers);
                String[] requiredHeaders = this.getRequiredDevHeaderArray(headersMap);
                this.tableHeader(requiredHeaders);
                int developersRowId = 0;
                for (Developer developer : developers) {
                    this.renderTeamMember((Contributor)developer, developersRowId, headersMap, javascript);
                    ++developersRowId;
                }
                this.endTable();
            }
            this.endSection();
            List contributors = this.model.getContributors();
            this.startSection(this.getI18nString("contributors.title"));
            if (this.isEmpty(contributors)) {
                this.paragraph(this.getI18nString("nocontributor"));
            } else {
                this.paragraph(this.getI18nString("contributors.intro"));
                this.startTable();
                Map<String, Boolean> headersMap = this.checkRequiredHeaders(contributors);
                String[] requiredHeaders = this.getRequiredContrHeaderArray(headersMap);
                this.tableHeader(requiredHeaders);
                int contributorsRowId = 0;
                for (Contributor contributor : contributors) {
                    this.renderTeamMember(contributor, contributorsRowId, headersMap, javascript);
                    ++contributorsRowId;
                }
                this.endTable();
            }
            javascript.append("}").append(SystemUtils.LINE_SEPARATOR).append(SystemUtils.LINE_SEPARATOR).append("window.onLoad = init();").append(SystemUtils.LINE_SEPARATOR);
            this.javaScript(javascript.toString());
            this.endSection();
            this.endSection();
        }

        private void renderTeamMember(Contributor member, int rowId, Map<String, Boolean> headersMap, StringBuilder javascript) {
            this.sink.tableRow();
            if (headersMap.get(IMAGE) == Boolean.TRUE && this.showAvatarImages) {
                Properties properties = member.getProperties();
                String picUrl = properties.getProperty("picUrl");
                if (StringUtils.isEmpty((String)picUrl)) {
                    picUrl = this.getGravatarUrl(member.getEmail());
                }
                if (StringUtils.isEmpty((String)picUrl)) {
                    picUrl = this.getSpacerGravatarUrl();
                }
                this.sink.tableCell();
                this.sink.figure();
                this.sink.figureGraphics(picUrl);
                this.sink.figure_();
                this.sink.tableCell_();
            }
            String type = "contributor";
            if (member instanceof Developer) {
                type = "developer";
                if (headersMap.get(ID) == Boolean.TRUE) {
                    String id = ((Developer)member).getId();
                    if (id == null) {
                        this.tableCell(null);
                    } else {
                        this.tableCell("<a name=\"" + id + "\"></a>" + id, true);
                    }
                }
            }
            if (headersMap.get(NAME) == Boolean.TRUE) {
                this.tableCell(member.getName());
            }
            if (headersMap.get(EMAIL) == Boolean.TRUE) {
                this.tableCell(TeamListRenderer.createLinkPatternedText((String)member.getEmail(), (String)member.getEmail()));
            }
            if (headersMap.get(URL) == Boolean.TRUE) {
                this.tableCellForUrl(member.getUrl());
            }
            if (headersMap.get(ORGANIZATION) == Boolean.TRUE) {
                this.tableCell(member.getOrganization());
            }
            if (headersMap.get(ORGANIZATION_URL) == Boolean.TRUE) {
                this.tableCellForUrl(member.getOrganizationUrl());
            }
            if (headersMap.get(ROLES) == Boolean.TRUE) {
                if (member.getRoles() != null) {
                    this.tableCell(StringUtils.join((Object[])member.getRoles().toArray(EMPTY_STRING_ARRAY), (String)", "));
                } else {
                    this.tableCell(null);
                }
            }
            if (headersMap.get(TIME_ZONE) == Boolean.TRUE) {
                this.tableCell(member.getTimezone());
                if (StringUtils.isNotEmpty((String)member.getTimezone()) && !ProjectInfoReportUtils.isNumber(member.getTimezone().trim())) {
                    String tz = member.getTimezone().trim();
                    try {
                        DateTimeZone.forID((String)tz);
                        this.sink.tableCell();
                        this.sink.rawText("<span id=\"" + type + "-" + rowId + "\">");
                        this.text(tz);
                        String offSet = String.valueOf(TimeZone.getTimeZone(tz).getRawOffset() / 3600000);
                        javascript.append("    offsetDate('").append(type).append("-").append(rowId).append("', '");
                        javascript.append(offSet).append("');").append(SystemUtils.LINE_SEPARATOR);
                        this.sink.rawText("</span>");
                        this.sink.tableCell_();
                    }
                    catch (IllegalArgumentException e) {
                        this.log.warn((CharSequence)("The time zone '" + tz + "' for the " + type + " '" + member.getName() + "' is not a recognised time zone, use a number in the range -12 and +14 instead of."));
                        this.sink.tableCell();
                        this.sink.rawText("<span id=\"" + type + "-" + rowId + "\">");
                        this.text(null);
                        this.sink.rawText("</span>");
                        this.sink.tableCell_();
                    }
                } else {
                    this.sink.tableCell();
                    this.sink.rawText("<span id=\"" + type + "-" + rowId + "\">");
                    if (StringUtils.isEmpty((String)member.getTimezone())) {
                        this.text(null);
                    } else {
                        float tz = ProjectInfoReportUtils.toFloat(member.getTimezone().trim(), -2.1474836E9f);
                        if (tz == -2.1474836E9f || !(tz >= -12.0f) || !(tz <= 14.0f)) {
                            this.text(null);
                            this.log.warn((CharSequence)("The time zone '" + member.getTimezone().trim() + "' for the " + type + " '" + member.getName() + "' is not a recognised time zone, use a number in the range -12 to +14 instead of."));
                        } else {
                            this.text(member.getTimezone().trim());
                            javascript.append("    offsetDate('").append(type).append("-").append(rowId).append("', '");
                            javascript.append(member.getTimezone()).append("');").append(SystemUtils.LINE_SEPARATOR);
                        }
                    }
                    this.sink.rawText("</span>");
                    this.sink.tableCell_();
                }
            }
            if (headersMap.get(PROPERTIES) == Boolean.TRUE) {
                Properties props = member.getProperties();
                if (props != null) {
                    this.tableCell(TeamListRenderer.propertiesToString((Properties)props));
                } else {
                    this.tableCell(null);
                }
            }
            this.sink.tableRow_();
        }

        private String getSpacerGravatarUrl() {
            return "http://www.gravatar.com/avatar/00000000000000000000000000000000?d=blank&f=y&s=60";
        }

        private String getGravatarUrl(String email) {
            if (email == null) {
                return null;
            }
            email = StringUtils.trim((String)email);
            email = email.toLowerCase();
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(email.getBytes());
                byte[] byteData = md.digest();
                StringBuilder sb = new StringBuilder();
                for (byte aByteData : byteData) {
                    sb.append(Integer.toString((aByteData & 0xFF) + 256, 16).substring(1));
                }
                return "http://www.gravatar.com/avatar/" + sb.toString() + "?d=mm&" + avatar_size;
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
        }

        private String img(String src) {
            if (src == null) {
                return "";
            }
            return "<img src='" + src + "'/>";
        }

        private String[] getRequiredContrHeaderArray(Map<String, Boolean> requiredHeaders) {
            ArrayList<String> requiredArray = new ArrayList<String>();
            String image = this.getI18nString("contributors.image");
            String name = this.getI18nString("contributors.name");
            String email = this.getI18nString("contributors.email");
            String url = this.getI18nString("contributors.url");
            String organization = this.getI18nString("contributors.organization");
            String organizationUrl = this.getI18nString("contributors.organizationurl");
            String roles = this.getI18nString("contributors.roles");
            String timeZone = this.getI18nString("contributors.timezone");
            String actualTime = this.getI18nString("contributors.actualtime");
            String properties = this.getI18nString("contributors.properties");
            if (requiredHeaders.get(IMAGE) == Boolean.TRUE && this.showAvatarImages) {
                requiredArray.add(image);
            }
            this.setRequiredArray(requiredHeaders, requiredArray, image, name, email, url, organization, organizationUrl, roles, timeZone, actualTime, properties);
            return requiredArray.toArray(new String[requiredArray.size()]);
        }

        private String[] getRequiredDevHeaderArray(Map<String, Boolean> requiredHeaders) {
            ArrayList<String> requiredArray = new ArrayList<String>();
            String image = this.getI18nString("developers.image");
            String id = this.getI18nString("developers.id");
            String name = this.getI18nString("developers.name");
            String email = this.getI18nString("developers.email");
            String url = this.getI18nString("developers.url");
            String organization = this.getI18nString("developers.organization");
            String organizationUrl = this.getI18nString("developers.organizationurl");
            String roles = this.getI18nString("developers.roles");
            String timeZone = this.getI18nString("developers.timezone");
            String actualTime = this.getI18nString("developers.actualtime");
            String properties = this.getI18nString("developers.properties");
            if (requiredHeaders.get(IMAGE) == Boolean.TRUE && this.showAvatarImages) {
                requiredArray.add(image);
            }
            if (requiredHeaders.get(ID) == Boolean.TRUE) {
                requiredArray.add(id);
            }
            this.setRequiredArray(requiredHeaders, requiredArray, image, name, email, url, organization, organizationUrl, roles, timeZone, actualTime, properties);
            return requiredArray.toArray(new String[requiredArray.size()]);
        }

        private void setRequiredArray(Map<String, Boolean> requiredHeaders, List<String> requiredArray, String image, String name, String email, String url, String organization, String organizationUrl, String roles, String timeZone, String actualTime, String properties) {
            if (requiredHeaders.get(NAME) == Boolean.TRUE) {
                requiredArray.add(name);
            }
            if (requiredHeaders.get(EMAIL) == Boolean.TRUE) {
                requiredArray.add(email);
            }
            if (requiredHeaders.get(URL) == Boolean.TRUE) {
                requiredArray.add(url);
            }
            if (requiredHeaders.get(ORGANIZATION) == Boolean.TRUE) {
                requiredArray.add(organization);
            }
            if (requiredHeaders.get(ORGANIZATION_URL) == Boolean.TRUE) {
                requiredArray.add(organizationUrl);
            }
            if (requiredHeaders.get(ROLES) == Boolean.TRUE) {
                requiredArray.add(roles);
            }
            if (requiredHeaders.get(TIME_ZONE) == Boolean.TRUE) {
                requiredArray.add(timeZone);
                requiredArray.add(actualTime);
            }
            if (requiredHeaders.get(PROPERTIES) == Boolean.TRUE) {
                requiredArray.add(properties);
            }
        }

        private Map<String, Boolean> checkRequiredHeaders(List<? extends Contributor> units) {
            HashMap<String, Boolean> requiredHeaders = new HashMap<String, Boolean>();
            requiredHeaders.put(IMAGE, Boolean.FALSE);
            requiredHeaders.put(ID, Boolean.FALSE);
            requiredHeaders.put(NAME, Boolean.FALSE);
            requiredHeaders.put(EMAIL, Boolean.FALSE);
            requiredHeaders.put(URL, Boolean.FALSE);
            requiredHeaders.put(ORGANIZATION, Boolean.FALSE);
            requiredHeaders.put(ORGANIZATION_URL, Boolean.FALSE);
            requiredHeaders.put(ROLES, Boolean.FALSE);
            requiredHeaders.put(TIME_ZONE, Boolean.FALSE);
            requiredHeaders.put(PROPERTIES, Boolean.FALSE);
            for (Contributor contributor : units) {
                boolean isJustAnImageProperty;
                Properties properties;
                boolean hasPicUrl;
                Developer developer;
                if (contributor instanceof Developer && StringUtils.isNotEmpty((String)(developer = (Developer)contributor).getId())) {
                    requiredHeaders.put(ID, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)contributor.getName())) {
                    requiredHeaders.put(NAME, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)contributor.getEmail())) {
                    requiredHeaders.put(EMAIL, Boolean.TRUE);
                    requiredHeaders.put(IMAGE, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)contributor.getUrl())) {
                    requiredHeaders.put(URL, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)contributor.getOrganization())) {
                    requiredHeaders.put(ORGANIZATION, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)contributor.getOrganizationUrl())) {
                    requiredHeaders.put(ORGANIZATION_URL, Boolean.TRUE);
                }
                if (!this.isEmpty(contributor.getRoles())) {
                    requiredHeaders.put(ROLES, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)contributor.getTimezone())) {
                    requiredHeaders.put(TIME_ZONE, Boolean.TRUE);
                }
                if (hasPicUrl = (properties = contributor.getProperties()).contains("picUrl")) {
                    requiredHeaders.put(IMAGE, Boolean.TRUE);
                }
                if ((isJustAnImageProperty = properties.size() == 1 && hasPicUrl) || properties.isEmpty()) continue;
                requiredHeaders.put(PROPERTIES, Boolean.TRUE);
            }
            return requiredHeaders;
        }

        private void tableCellForUrl(String url) {
            this.sink.tableCell();
            if (StringUtils.isEmpty((String)url)) {
                this.text(url);
            } else {
                this.link(url, url);
            }
            this.sink.tableCell_();
        }

        private boolean isEmpty(List<?> list) {
            return list == null || list.isEmpty();
        }
    }
}

