/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.apache.maven.scm.provider.hg.repository.HgScmProviderRepository;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="scm")
public class ScmReport
extends AbstractProjectInfoReport {
    @Component
    protected ScmManager scmManager;
    @Parameter(defaultValue="${project.artifactId}", required=true)
    private String checkoutDirectoryName;
    @Parameter(defaultValue="${project.scm.connection}")
    private String anonymousConnection;
    @Parameter(defaultValue="${project.scm.developerConnection}")
    private String developerConnection;
    @Parameter(defaultValue="${project.scm.url}")
    private String webAccessUrl;

    public void executeReport(Locale locale) {
        ScmRenderer r = new ScmRenderer(this.getLog(), this.scmManager, this.getSink(), this.getProject().getModel(), this.getI18N(locale), locale, this.checkoutDirectoryName, this.webAccessUrl, this.anonymousConnection, this.developerConnection);
        r.render();
    }

    public String getOutputName() {
        return "source-repository";
    }

    protected String getI18Nsection() {
        return "scm";
    }

    private static class ScmRenderer
    extends AbstractProjectInfoRenderer {
        private Log log;
        private Model model;
        private ScmManager scmManager;
        private String anonymousConnection;
        private String devConnection;
        private String checkoutDirectoryName;
        private String webAccessUrl;

        ScmRenderer(Log log, ScmManager scmManager, Sink sink, Model model, I18N i18n, Locale locale, String checkoutDirName, String webAccessUrl, String anonymousConnection, String devConnection) {
            super(sink, i18n, locale);
            this.log = log;
            this.scmManager = scmManager;
            this.model = model;
            this.checkoutDirectoryName = checkoutDirName;
            this.webAccessUrl = webAccessUrl;
            this.anonymousConnection = anonymousConnection;
            this.devConnection = devConnection;
        }

        protected String getI18Nsection() {
            return "scm";
        }

        public void renderBody() {
            Scm scm = this.model.getScm();
            if (scm == null) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("noscm"));
                this.endSection();
                return;
            }
            if (StringUtils.isEmpty((String)this.anonymousConnection) && StringUtils.isEmpty((String)this.devConnection) && StringUtils.isEmpty((String)scm.getUrl())) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("noscm"));
                this.endSection();
                return;
            }
            ScmRepository anonymousRepository = this.getScmRepository(this.anonymousConnection);
            ScmRepository devRepository = this.getScmRepository(this.devConnection);
            this.renderOverViewSection(anonymousRepository);
            this.renderWebAccesSection(this.webAccessUrl);
            this.renderAnonymousAccessSection(anonymousRepository);
            this.renderDeveloperAccessSection(devRepository);
            this.renderAccessBehindFirewallSection(devRepository);
            this.renderAccessThroughProxySection(anonymousRepository, devRepository);
        }

        private void renderOverViewSection(ScmRepository anonymousRepository) {
            this.startSection(this.getI18nString("overview.title"));
            if (ScmRenderer.isScmSystem(anonymousRepository, "clearcase")) {
                this.sink.paragraph();
                this.linkPatternedText(this.getI18nString("clearcase.intro"));
                this.sink.paragraph_();
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "cvs")) {
                this.sink.paragraph();
                this.linkPatternedText(this.getI18nString("cvs.intro"));
                this.sink.paragraph_();
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "hg")) {
                this.sink.paragraph();
                this.linkPatternedText(this.getI18nString("hg.intro"));
                this.sink.paragraph_();
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "perforce")) {
                this.sink.paragraph();
                this.linkPatternedText(this.getI18nString("perforce.intro"));
                this.sink.paragraph_();
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "starteam")) {
                this.sink.paragraph();
                this.linkPatternedText(this.getI18nString("starteam.intro"));
                this.sink.paragraph_();
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "svn")) {
                this.sink.paragraph();
                this.linkPatternedText(this.getI18nString("svn.intro"));
                this.sink.paragraph_();
            } else {
                this.paragraph(this.getI18nString("general.intro"));
            }
            this.endSection();
        }

        private void renderWebAccesSection(String scmUrl) {
            this.startSection(this.getI18nString("webaccess.title"));
            if (StringUtils.isEmpty((String)scmUrl)) {
                this.paragraph(this.getI18nString("webaccess.nourl"));
            } else {
                this.paragraph(this.getI18nString("webaccess.url"));
                this.verbatimLink(scmUrl, scmUrl);
            }
            this.endSection();
        }

        private void renderAnonymousAccessSection(ScmRepository anonymousRepository) {
            if (ScmRenderer.isScmSystem(anonymousRepository, "clearcase") || ScmRenderer.isScmSystem(anonymousRepository, "perforce") || ScmRenderer.isScmSystem(anonymousRepository, "starteam") || StringUtils.isEmpty((String)this.anonymousConnection)) {
                return;
            }
            this.startSection(this.getI18nString("anonymousaccess.title"));
            if (anonymousRepository != null && ScmRenderer.isScmSystem(anonymousRepository, "cvs")) {
                CvsScmProviderRepository cvsRepo = (CvsScmProviderRepository)anonymousRepository.getProviderRepository();
                this.anonymousAccessCVS(cvsRepo);
            }
            if (anonymousRepository != null && ScmRenderer.isScmSystem(anonymousRepository, "hg")) {
                HgScmProviderRepository hgRepo = (HgScmProviderRepository)anonymousRepository.getProviderRepository();
                this.anonymousAccessMercurial(hgRepo);
            } else if (anonymousRepository != null && ScmRenderer.isScmSystem(anonymousRepository, "svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)anonymousRepository.getProviderRepository();
                this.anonymousAccessSVN(svnRepo);
            } else {
                this.paragraph(this.getI18nString("anonymousaccess.general.intro"));
                this.verbatimText(this.anonymousConnection.substring(4));
            }
            this.endSection();
        }

        private void renderDeveloperAccessSection(ScmRepository devRepository) {
            if (StringUtils.isEmpty((String)this.devConnection)) {
                return;
            }
            this.startSection(this.getI18nString("devaccess.title"));
            if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "clearcase")) {
                this.developerAccessClearCase();
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "cvs")) {
                CvsScmProviderRepository cvsRepo = (CvsScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessCVS(cvsRepo);
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "hg")) {
                HgScmProviderRepository hgRepo = (HgScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessMercurial(hgRepo);
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "perforce")) {
                PerforceScmProviderRepository perforceRepo = (PerforceScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessPerforce(perforceRepo);
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "starteam")) {
                StarteamScmProviderRepository starteamRepo = (StarteamScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessStarteam(starteamRepo);
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessSVN(svnRepo);
            } else {
                this.paragraph(this.getI18nString("devaccess.general.intro"));
                this.verbatimText(this.devConnection.substring(4));
            }
            this.endSection();
        }

        private void renderAccessBehindFirewallSection(ScmRepository devRepository) {
            this.startSection(this.getI18nString("accessbehindfirewall.title"));
            if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)devRepository.getProviderRepository();
                this.paragraph(this.getI18nString("accessbehindfirewall.svn.intro"));
                StringBuffer sb = new StringBuffer();
                sb.append("$ svn checkout ").append(svnRepo.getUrl());
                sb.append(" ").append(this.checkoutDirectoryName);
                this.verbatimText(sb.toString());
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "cvs")) {
                this.linkPatternedText(this.getI18nString("accessbehindfirewall.cvs.intro"));
            } else {
                this.paragraph(this.getI18nString("accessbehindfirewall.general.intro"));
            }
            this.endSection();
        }

        private void renderAccessThroughProxySection(ScmRepository anonymousRepository, ScmRepository devRepository) {
            if (ScmRenderer.isScmSystem(anonymousRepository, "svn") || ScmRenderer.isScmSystem(devRepository, "svn")) {
                this.startSection(this.getI18nString("accessthroughtproxy.title"));
                this.paragraph(this.getI18nString("accessthroughtproxy.svn.intro1"));
                this.paragraph(this.getI18nString("accessthroughtproxy.svn.intro2"));
                this.paragraph(this.getI18nString("accessthroughtproxy.svn.intro3"));
                StringBuffer sb = new StringBuffer();
                sb.append("[global]");
                sb.append(SystemUtils.LINE_SEPARATOR);
                sb.append("http-proxy-host = your.proxy.name").append(SystemUtils.LINE_SEPARATOR);
                sb.append("http-proxy-port = 3128").append(SystemUtils.LINE_SEPARATOR);
                this.verbatimText(sb.toString());
                this.endSection();
            }
        }

        private void developerAccessClearCase() {
            this.paragraph(this.getI18nString("devaccess.clearcase.intro"));
            StringBuffer command = new StringBuffer();
            command.append("$ cleartool checkout ");
            this.verbatimText(command.toString());
        }

        private void anonymousAccessCVS(CvsScmProviderRepository cvsRepo) {
            this.paragraph(this.getI18nString("anonymousaccess.cvs.intro"));
            StringBuffer command = new StringBuffer();
            command.append("$ cvs -d ").append(cvsRepo.getCvsRoot()).append(" login");
            command.append(SystemUtils.LINE_SEPARATOR);
            command.append("$ cvs -z3 -d ").append(cvsRepo.getCvsRoot());
            command.append(" co ").append(cvsRepo.getModule());
            this.verbatimText(command.toString());
        }

        private void anonymousAccessMercurial(HgScmProviderRepository hgRepo) {
            this.sink.paragraph();
            this.linkPatternedText(this.getI18nString("anonymousaccess.hg.intro"));
            this.sink.paragraph_();
            StringBuffer command = new StringBuffer();
            command.append("$ hg clone ").append(hgRepo.getURI());
            this.verbatimText(command.toString());
        }

        private void developerAccessCVS(CvsScmProviderRepository cvsRepo) {
            this.paragraph(this.getI18nString("devaccess.cvs.intro"));
            String cvsRoot = StringUtils.replace((String)cvsRepo.getCvsRoot(), (String)cvsRepo.getUser(), (String)"username");
            StringBuffer command = new StringBuffer();
            command.append("$ cvs -d ").append(cvsRoot).append(" login");
            command.append(SystemUtils.LINE_SEPARATOR);
            command.append("$ cvs -z3 -d ").append(cvsRoot).append(" co ").append(cvsRepo.getModule());
            this.verbatimText(command.toString());
        }

        private void developerAccessMercurial(HgScmProviderRepository hgRepo) {
            this.sink.paragraph();
            this.linkPatternedText(this.getI18nString("devaccess.hg.intro"));
            this.sink.paragraph_();
            StringBuffer command = new StringBuffer();
            command.append("$ hg clone ");
            command.append(hgRepo.getURI());
            this.verbatimText(command.toString());
        }

        private void developerAccessPerforce(PerforceScmProviderRepository perforceRepo) {
            this.paragraph(this.getI18nString("devaccess.perforce.intro"));
            StringBuffer command = new StringBuffer();
            command.append("$ p4");
            if (!StringUtils.isEmpty((String)perforceRepo.getHost())) {
                command.append(" -H ").append(perforceRepo.getHost());
            }
            if (perforceRepo.getPort() > 0) {
                command.append(" -p ").append(perforceRepo.getPort());
            }
            command.append(" -u username");
            command.append(" -P password");
            command.append(" ");
            command.append(perforceRepo.getPath());
            command.append(SystemUtils.LINE_SEPARATOR);
            command.append("$ p4 submit -c \"A comment\"");
            this.verbatimText(command.toString());
        }

        private void developerAccessStarteam(StarteamScmProviderRepository starteamRepo) {
            this.paragraph(this.getI18nString("devaccess.starteam.intro"));
            StringBuffer command = new StringBuffer();
            String fullUrl = StringUtils.replace((String)starteamRepo.getFullUrl(), (String)starteamRepo.getUser(), (String)"username");
            fullUrl = StringUtils.replace((String)fullUrl, (String)starteamRepo.getPassword(), (String)"password");
            command.append("$ stcmd co -x -nologo -stop -p ");
            command.append(fullUrl);
            command.append(" -is");
            command.append(SystemUtils.LINE_SEPARATOR);
            command.append("$ stcmd ci -x -nologo -stop -p ");
            command.append(fullUrl);
            command.append(" -f NCI -is");
            this.verbatimText(command.toString());
        }

        private void anonymousAccessSVN(SvnScmProviderRepository svnRepo) {
            this.paragraph(this.getI18nString("anonymousaccess.svn.intro"));
            StringBuffer sb = new StringBuffer();
            sb.append("$ svn checkout ").append(svnRepo.getUrl()).append(" ").append(this.checkoutDirectoryName);
            this.verbatimText(sb.toString());
        }

        private void developerAccessSVN(SvnScmProviderRepository svnRepo) {
            if (svnRepo.getUrl() != null) {
                if (svnRepo.getUrl().startsWith("https://")) {
                    this.paragraph(this.getI18nString("devaccess.svn.intro1.https"));
                } else if (svnRepo.getUrl().startsWith("svn://")) {
                    this.paragraph(this.getI18nString("devaccess.svn.intro1.svn"));
                } else if (svnRepo.getUrl().startsWith("svn+ssh://")) {
                    this.paragraph(this.getI18nString("devaccess.svn.intro1.svnssh"));
                } else {
                    this.paragraph(this.getI18nString("devaccess.svn.intro1.other"));
                }
            }
            StringBuffer sb = new StringBuffer();
            sb.append("$ svn checkout ").append(svnRepo.getUrl()).append(" ").append(this.checkoutDirectoryName);
            this.verbatimText(sb.toString());
            this.paragraph(this.getI18nString("devaccess.svn.intro2"));
            sb = new StringBuffer();
            sb.append("$ svn commit --username your-username -m \"A message\"");
            this.verbatimText(sb.toString());
        }

        public ScmRepository getScmRepository(String scmUrl) {
            ScmRepository repo;
            block13: {
                if (StringUtils.isEmpty((String)scmUrl)) {
                    return null;
                }
                repo = null;
                ArrayList<String> messages = new ArrayList<String>();
                try {
                    messages.addAll(this.scmManager.validateScmRepository(scmUrl));
                }
                catch (Exception e) {
                    messages.add(e.getMessage());
                }
                if (messages.size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    boolean isIntroAdded = false;
                    for (String msg : messages) {
                        if (msg.startsWith("No such provider")) continue;
                        if (!isIntroAdded) {
                            sb.append("This SCM url '" + scmUrl + "' is invalid due to the following errors:");
                            sb.append(SystemUtils.LINE_SEPARATOR);
                            isIntroAdded = true;
                        }
                        sb.append(" * ");
                        sb.append(msg);
                        sb.append(SystemUtils.LINE_SEPARATOR);
                    }
                    if (StringUtils.isNotEmpty((String)sb.toString())) {
                        sb.append("For more information about SCM URL Format, please refer to: http://maven.apache.org/scm/scm-url-format.html");
                        throw new IllegalArgumentException(sb.toString());
                    }
                }
                try {
                    repo = this.scmManager.makeScmRepository(scmUrl);
                }
                catch (NoSuchScmProviderException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((CharSequence)e.getMessage(), (Throwable)e);
                    }
                }
                catch (ScmRepositoryException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((CharSequence)e.getMessage(), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    if (!this.log.isDebugEnabled()) break block13;
                    this.log.debug((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
            return repo;
        }

        private static boolean isScmSystem(ScmRepository scmRepository, String scmProvider) {
            if (StringUtils.isEmpty((String)scmProvider)) {
                return false;
            }
            return scmRepository != null && scmProvider.equalsIgnoreCase(scmRepository.getProvider());
        }
    }
}

