/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Model;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class TeamListReport
extends AbstractProjectInfoReport {
    public String getName(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.team-list.name");
    }

    public String getDescription(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.team-list.description");
    }

    public void executeReport(Locale locale) {
        TeamListRenderer r = new TeamListRenderer(this.getSink(), this.project.getModel(), this.i18n, locale);
        r.render();
    }

    public String getOutputName() {
        return "team-list";
    }

    private static class TeamListRenderer
    extends AbstractMavenReportRenderer {
        private Model model;
        private I18N i18n;
        private Locale locale;
        private static final String[] EMPTY_STRING_ARRAY = new String[0];

        TeamListRenderer(Sink sink, Model model, I18N i18n, Locale locale) {
            super(sink);
            this.model = model;
            this.i18n = i18n;
            this.locale = locale;
        }

        public String getTitle() {
            return this.i18n.getString("project-info-report", this.locale, "report.team-list.title");
        }

        public void renderBody() {
            Properties props;
            Iterator i;
            String properties;
            String actualTime;
            String timeZone;
            String roles;
            String organizationUrl;
            String organization;
            String url;
            String email;
            String name;
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.team-list.intro.title"));
            StringBuffer javascript = new StringBuffer("function offsetDate(id, offset) {\n");
            javascript.append("    var now = new Date();\n");
            javascript.append("    var nowTime = now.getTime();\n");
            javascript.append("    var localOffset = now.getTimezoneOffset();\n");
            javascript.append("    var developerTime = nowTime + ( offset * 60 * 60 * 1000 ) + ( localOffset * 60 * 1000 );\n");
            javascript.append("    var developerDate = new Date(developerTime);\n");
            javascript.append("\n");
            javascript.append("    document.getElementById(id).innerHTML = developerDate;\n");
            javascript.append("}\n");
            javascript.append("\n");
            javascript.append("function init(){\n");
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.team-list.intro.description1"));
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.team-list.intro.description2"));
            List developers = this.model.getDevelopers();
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.title"));
            if (developers == null || developers.isEmpty()) {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.team-list.nodeveloper"));
            } else {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.intro"));
                this.startTable();
                String id = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.id");
                name = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.name");
                email = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.email");
                url = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.url");
                organization = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.organization");
                organizationUrl = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.organizationurl");
                roles = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.roles");
                timeZone = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.timezone");
                actualTime = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.actualtime");
                properties = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.properties");
                this.tableHeader(new String[]{id, name, email, url, organization, organizationUrl, roles, timeZone, actualTime, properties});
                int developersRows = 0;
                i = developers.iterator();
                while (i.hasNext()) {
                    Developer developer = (Developer)i.next();
                    this.sink.tableRow();
                    this.tableCell(developer.getId());
                    this.tableCell(developer.getName());
                    this.tableCell(TeamListRenderer.createLinkPatternedText((String)developer.getEmail(), (String)developer.getEmail()));
                    this.tableCell(TeamListRenderer.createLinkPatternedText((String)developer.getUrl(), (String)developer.getUrl()));
                    this.tableCell(developer.getOrganization());
                    this.tableCell(TeamListRenderer.createLinkPatternedText((String)developer.getOrganizationUrl(), (String)developer.getOrganizationUrl()));
                    if (developer.getRoles() != null) {
                        this.tableCell(StringUtils.join((Object[])developer.getRoles().toArray(EMPTY_STRING_ARRAY), (String)", "));
                    } else {
                        this.tableCell(null);
                    }
                    this.tableCell(developer.getTimezone());
                    this.sink.tableCell();
                    this.sink.rawText("<span id=\"developer-" + developersRows + "\">");
                    this.text(developer.getTimezone());
                    if (!StringUtils.isEmpty((String)developer.getTimezone())) {
                        javascript.append("    offsetDate('developer-").append(developersRows).append("', '");
                        javascript.append(developer.getTimezone());
                        javascript.append("');\n");
                    }
                    this.sink.rawText("</span>");
                    this.sink.tableCell_();
                    props = developer.getProperties();
                    if (props != null) {
                        this.tableCell(TeamListRenderer.propertiesToString((Properties)props));
                    } else {
                        this.tableCell(null);
                    }
                    this.sink.tableRow_();
                    ++developersRows;
                }
                this.endTable();
            }
            this.endSection();
            List contributors = this.model.getContributors();
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.title"));
            if (contributors == null || contributors.isEmpty()) {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.team-list.nocontributor"));
            } else {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.intro"));
                this.startTable();
                name = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.name");
                email = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.email");
                url = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.url");
                organization = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.organization");
                organizationUrl = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.organizationurl");
                roles = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.roles");
                timeZone = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.timezone");
                actualTime = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.actualtime");
                properties = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.properties");
                this.tableHeader(new String[]{name, email, url, organization, organizationUrl, roles, timeZone, actualTime, properties});
                int contributorsRows = 0;
                i = contributors.iterator();
                while (i.hasNext()) {
                    Contributor contributor = (Contributor)i.next();
                    this.sink.tableRow();
                    this.tableCell(contributor.getName());
                    this.tableCell(TeamListRenderer.createLinkPatternedText((String)contributor.getEmail(), (String)contributor.getEmail()));
                    this.tableCell(TeamListRenderer.createLinkPatternedText((String)contributor.getUrl(), (String)contributor.getUrl()));
                    this.tableCell(contributor.getOrganization());
                    this.tableCell(TeamListRenderer.createLinkPatternedText((String)contributor.getOrganizationUrl(), (String)contributor.getOrganizationUrl()));
                    if (contributor.getRoles() != null) {
                        this.tableCell(StringUtils.join((Object[])contributor.getRoles().toArray(EMPTY_STRING_ARRAY), (String)", "));
                    } else {
                        this.tableCell(null);
                    }
                    this.tableCell(contributor.getTimezone());
                    this.sink.tableCell();
                    this.sink.rawText("<span id=\"contributor-" + contributorsRows + "\">");
                    this.text(contributor.getTimezone());
                    if (!StringUtils.isEmpty((String)contributor.getTimezone())) {
                        javascript.append("    offsetDate('contributor-").append(contributorsRows).append("', '");
                        javascript.append(contributor.getTimezone());
                        javascript.append("');\n");
                    }
                    this.sink.rawText("</span>");
                    this.sink.tableCell_();
                    props = contributor.getProperties();
                    if (props != null) {
                        this.tableCell(TeamListRenderer.propertiesToString((Properties)props));
                    } else {
                        this.tableCell(null);
                    }
                    this.sink.tableRow_();
                    ++contributorsRows;
                }
                this.endTable();
            }
            this.endSection();
            this.endSection();
            javascript.append("}\n").append("\n").append("window.onLoad = init();\n");
            this.javaScript(javascript.toString());
        }
    }
}

