/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.pmd.AbstractPmdViolationCheckMojo;
import org.apache.maven.plugin.pmd.ViolationDetails;
import org.apache.maven.plugin.pmd.model.PmdErrorDetail;
import org.apache.maven.plugin.pmd.model.PmdFile;
import org.apache.maven.plugin.pmd.model.Violation;
import org.apache.maven.plugin.pmd.model.io.xpp3.PmdXpp3Reader;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdViolationCheckMojo
extends AbstractPmdViolationCheckMojo<Violation> {
    private int failurePriority;
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.executeCheck("pmd.xml", "violation", "PMD violation", this.failurePriority);
        }
    }

    @Override
    protected void printError(Violation item, String severity) {
        StringBuffer buff = new StringBuffer(100);
        buff.append("PMD " + severity + ": ");
        if (item.getViolationClass() != null) {
            if (item.getViolationPackage() != null) {
                buff.append(item.getViolationPackage());
                buff.append(".");
            }
            buff.append(item.getViolationClass());
        } else {
            buff.append(item.getFileName());
        }
        buff.append(":");
        buff.append(item.getBeginline());
        buff.append(" Rule:").append(item.getRule());
        buff.append(" Priority:").append(item.getPriority());
        buff.append(" ").append(item.getText()).append(".");
        this.getLog().info((CharSequence)buff.toString());
    }

    @Override
    protected List<Violation> getErrorDetails(File pmdFile) throws XmlPullParserException, IOException {
        PmdXpp3Reader reader = new PmdXpp3Reader();
        PmdErrorDetail details = reader.read(new FileReader(pmdFile), false);
        ArrayList<Violation> violations = new ArrayList<Violation>();
        for (PmdFile file : details.getFiles()) {
            String fullPath = file.getName();
            for (Violation violation : file.getViolations()) {
                violation.setFileName(this.getFilename(fullPath, violation.getViolationPackage()));
                violations.add(violation);
            }
        }
        return violations;
    }

    @Override
    protected int getPriority(Violation errorDetail) {
        return errorDetail.getPriority();
    }

    @Override
    protected ViolationDetails<Violation> newViolationDetailsInstance() {
        return new ViolationDetails<Violation>();
    }

    private String getFilename(String fullpath, String pkg) {
        int index = fullpath.lastIndexOf(File.separatorChar);
        while (StringUtils.isNotEmpty((String)pkg)) {
            index = fullpath.substring(0, index).lastIndexOf(File.separatorChar);
            int dot = pkg.indexOf(46);
            if (dot < 0) break;
            pkg = pkg.substring(dot + 1);
        }
        return fullpath.substring(index + 1);
    }
}

