/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pdf;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateBean {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final SimpleDateFormat YEAR = new SimpleDateFormat("yyyy", Locale.US);
    private static final SimpleDateFormat MONTH = new SimpleDateFormat("MM", Locale.US);
    private static final SimpleDateFormat DAY = new SimpleDateFormat("dd", Locale.US);
    private static final SimpleDateFormat HOUR = new SimpleDateFormat("HH", Locale.US);
    private static final SimpleDateFormat MINUTE = new SimpleDateFormat("mm", Locale.US);
    private static final SimpleDateFormat SECOND = new SimpleDateFormat("ss", Locale.US);
    private static final SimpleDateFormat MILLI_SECOND = new SimpleDateFormat("SSS", Locale.US);
    private static final SimpleDateFormat DATE = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    private static final SimpleDateFormat TIME = new SimpleDateFormat("HH:mm:ss'Z'", Locale.US);
    private static final SimpleDateFormat DATE_TIME = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    private Date date;

    public DateBean() {
        this(new Date());
    }

    public DateBean(Date date) {
        this.date = date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getYear() {
        DateBean dateBean = this;
        synchronized (dateBean) {
            return YEAR.format(this.date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMonth() {
        DateBean dateBean = this;
        synchronized (dateBean) {
            return MONTH.format(this.date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDay() {
        DateBean dateBean = this;
        synchronized (dateBean) {
            return DAY.format(this.date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHour() {
        DateBean dateBean = this;
        synchronized (dateBean) {
            return HOUR.format(this.date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMinute() {
        DateBean dateBean = this;
        synchronized (dateBean) {
            return MINUTE.format(this.date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSecond() {
        DateBean dateBean = this;
        synchronized (dateBean) {
            return SECOND.format(this.date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMillisecond() {
        DateBean dateBean = this;
        synchronized (dateBean) {
            return MILLI_SECOND.format(this.date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDate() {
        DateBean dateBean = this;
        synchronized (dateBean) {
            return DATE.format(this.date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTime() {
        DateBean dateBean = this;
        synchronized (dateBean) {
            return TIME.format(this.date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDateTime() {
        DateBean dateBean = this;
        synchronized (dateBean) {
            return DATE_TIME.format(this.date);
        }
    }

    static {
        YEAR.setTimeZone(UTC_TIME_ZONE);
        MONTH.setTimeZone(UTC_TIME_ZONE);
        DAY.setTimeZone(UTC_TIME_ZONE);
        HOUR.setTimeZone(UTC_TIME_ZONE);
        MINUTE.setTimeZone(UTC_TIME_ZONE);
        SECOND.setTimeZone(UTC_TIME_ZONE);
        MILLI_SECOND.setTimeZone(UTC_TIME_ZONE);
        DATE.setTimeZone(UTC_TIME_ZONE);
        TIME.setTimeZone(UTC_TIME_ZONE);
        DATE_TIME.setTimeZone(UTC_TIME_ZONE);
    }
}

