/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jarsigner;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.jarsigner.AbstractJarsignerMojo;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class JarsignerSignMojo
extends AbstractJarsignerMojo {
    private String keystore;
    private String storepass;
    private String keypass;
    private String sigfile;
    private String storetype;
    private String providerName;
    private String providerClass;
    private String providerArg;
    private String alias;
    private boolean removeExistingSignatures;

    protected Commandline getCommandline(File archive, Commandline commandLine) {
        if (archive == null) {
            throw new NullPointerException("archive");
        }
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        if (!StringUtils.isEmpty((String)this.keystore)) {
            commandLine.createArg().setValue("-keystore");
            commandLine.createArg().setValue(this.keystore);
        }
        if (!StringUtils.isEmpty((String)this.storepass)) {
            commandLine.createArg().setValue("-storepass");
            commandLine.createArg().setValue(this.storepass);
        }
        if (!StringUtils.isEmpty((String)this.keypass)) {
            commandLine.createArg().setValue("-keypass");
            commandLine.createArg().setValue(this.keypass);
        }
        if (!StringUtils.isEmpty((String)this.storetype)) {
            commandLine.createArg().setValue("-storetype");
            commandLine.createArg().setValue(this.storetype);
        }
        if (!StringUtils.isEmpty((String)this.providerName)) {
            commandLine.createArg().setValue("-providerName");
            commandLine.createArg().setValue(this.providerName);
        }
        if (!StringUtils.isEmpty((String)this.providerClass)) {
            commandLine.createArg().setValue("-providerClass");
            commandLine.createArg().setValue(this.providerClass);
        }
        if (!StringUtils.isEmpty((String)this.providerArg)) {
            commandLine.createArg().setValue("-providerArg");
            commandLine.createArg().setValue(this.providerArg);
        }
        if (!StringUtils.isEmpty((String)this.sigfile)) {
            commandLine.createArg().setValue("-sigfile");
            commandLine.createArg().setValue(this.sigfile);
        }
        commandLine.createArg().setFile(archive);
        if (!StringUtils.isEmpty((String)this.alias)) {
            commandLine.createArg().setValue(this.alias);
        }
        return commandLine;
    }

    protected String getCommandlineInfo(Commandline commandLine) {
        String commandLineInfo;
        String string = commandLineInfo = commandLine != null ? commandLine.toString() : null;
        if (commandLineInfo != null) {
            commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.keypass, (String)"'*****'");
            commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.storepass, (String)"'*****'");
        }
        return commandLineInfo;
    }

    protected void preProcessArchive(File archive) throws MojoExecutionException {
        if (this.removeExistingSignatures) {
            this.unsignArchive(archive);
        }
    }

    private void unsignArchive(File jarFile) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Unsigning " + jarFile));
        }
        File unsignedFile = new File(jarFile.getAbsolutePath() + ".unsigned");
        ZipInputStream zis = null;
        ZipOutputStream zos = null;
        try {
            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarFile)));
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(unsignedFile)));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (this.isSignatureFile(ze.getName())) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("  Removing " + ze.getName()));
                    }
                } else {
                    zos.putNextEntry(ze);
                    IOUtil.copy((InputStream)zis, (OutputStream)zos);
                }
                ze = zis.getNextEntry();
            }
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Failed to unsign archive " + jarFile + ": " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(zis);
                IOUtil.close(zos);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)zis);
        IOUtil.close((OutputStream)zos);
        try {
            FileUtils.rename((File)unsignedFile, (File)jarFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to unsign archive " + jarFile + ": " + e.getMessage(), (Exception)e);
        }
    }

    private boolean isSignatureFile(String entryName) {
        if (entryName.regionMatches(true, 0, "META-INF", 0, 8) && (entryName = entryName.replace('\\', '/')).indexOf(47) == 8 && entryName.lastIndexOf(47) == 8) {
            if (entryName.regionMatches(true, entryName.length() - 3, ".SF", 0, 3)) {
                return true;
            }
            if (entryName.regionMatches(true, entryName.length() - 4, ".DSA", 0, 4)) {
                return true;
            }
            if (entryName.regionMatches(true, entryName.length() - 4, ".RSA", 0, 4)) {
                return true;
            }
        }
        return false;
    }
}

