/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jarsigner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractJarsignerMojo
extends AbstractMojo {
    private boolean verbose;
    private String maxMemory;
    private File archive;
    private File archiveDirectory;
    private String[] includes = new String[]{"**/*.?ar"};
    private String[] excludes = new String[0];
    private String[] arguments;
    private boolean skip;
    private boolean processMainArtifact;
    private boolean processAttachedArtifacts;
    private Boolean attachments;
    private MavenProject project;
    private String executable;

    public final void execute() throws MojoExecutionException {
        if (!this.skip) {
            this.executable = this.getExecutable();
            int processed = 0;
            if (this.archive != null) {
                this.processArchive(this.archive);
                ++processed;
            } else {
                if (this.processMainArtifact) {
                    processed += this.processArtifact(this.project.getArtifact()) ? 1 : 0;
                }
                if (this.processAttachedArtifacts && !Boolean.FALSE.equals(this.attachments)) {
                    Iterator it = this.project.getAttachedArtifacts().iterator();
                    while (it.hasNext()) {
                        Artifact artifact = (Artifact)it.next();
                        processed += this.processArtifact(artifact) ? 1 : 0;
                    }
                } else if (this.verbose) {
                    this.getLog().info((CharSequence)this.getMessage("ignoringAttachments"));
                } else {
                    this.getLog().debug((CharSequence)this.getMessage("ignoringAttachments"));
                }
                if (this.archiveDirectory != null) {
                    List jarFiles;
                    String includeList = this.includes != null ? StringUtils.join((Object[])this.includes, (String)",") : null;
                    String excludeList = this.excludes != null ? StringUtils.join((Object[])this.excludes, (String)",") : null;
                    try {
                        jarFiles = FileUtils.getFiles((File)this.archiveDirectory, (String)includeList, (String)excludeList);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Failed to scan archive directory for JARs: " + e.getMessage(), (Exception)e);
                    }
                    Iterator it = jarFiles.iterator();
                    while (it.hasNext()) {
                        File jarFile = (File)it.next();
                        this.processArchive(jarFile);
                        ++processed;
                    }
                }
            }
            this.getLog().info((CharSequence)this.getMessage("processed", new Integer(processed)));
        } else {
            this.getLog().info((CharSequence)this.getMessage("disabled", null));
        }
    }

    protected abstract Commandline getCommandline(File var1, Commandline var2);

    protected String getCommandlineInfo(Commandline commandLine) {
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        return commandLine.toString();
    }

    private boolean isJarFile(Artifact artifact) {
        return artifact != null && artifact.getFile() != null && this.isJarFile(artifact.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isJarFile(File file) {
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
            try {
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    if (ze.getName().startsWith("META-INF/") || ze.getName().endsWith(".class")) {
                        boolean bl = true;
                        return bl;
                    }
                    ze = zis.getNextEntry();
                }
                return false;
            }
            finally {
                zis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean processArtifact(Artifact artifact) throws MojoExecutionException {
        if (artifact == null) {
            throw new NullPointerException("artifact");
        }
        boolean processed = false;
        if (this.isJarFile(artifact)) {
            this.processArchive(artifact.getFile());
            processed = true;
        } else if (this.verbose) {
            this.getLog().info((CharSequence)this.getMessage("unsupported", artifact));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)this.getMessage("unsupported", artifact));
        }
        return processed;
    }

    protected void preProcessArchive(File archive) throws MojoExecutionException {
    }

    private void processArchive(File archive) throws MojoExecutionException {
        if (archive == null) {
            throw new NullPointerException("archive");
        }
        this.preProcessArchive(archive);
        if (this.verbose) {
            this.getLog().info((CharSequence)this.getMessage("processing", archive));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)this.getMessage("processing", archive));
        }
        Commandline commandLine = new Commandline();
        commandLine.setExecutable(this.executable);
        commandLine.setWorkingDirectory(this.project.getBasedir());
        if (this.verbose) {
            commandLine.createArg().setValue("-verbose");
        }
        if (StringUtils.isNotEmpty((String)this.maxMemory)) {
            commandLine.createArg().setValue("-J-Xmx" + this.maxMemory);
        }
        if (this.arguments != null) {
            commandLine.addArguments(this.arguments);
        }
        commandLine = this.getCommandline(archive, commandLine);
        try {
            int result;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)this.getMessage("command", this.getCommandlineInfo(commandLine)));
            }
            if ((result = CommandLineUtils.executeCommandLine((Commandline)commandLine, (InputStream)new InputStream(){

                public int read() {
                    return -1;
                }
            }, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String line) {
                    if (AbstractJarsignerMojo.this.verbose) {
                        AbstractJarsignerMojo.this.getLog().info((CharSequence)line);
                    } else {
                        AbstractJarsignerMojo.this.getLog().debug((CharSequence)line);
                    }
                }
            }, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String line) {
                    AbstractJarsignerMojo.this.getLog().warn((CharSequence)line);
                }
            })) != 0) {
                throw new MojoExecutionException(this.getMessage("failure", this.getCommandlineInfo(commandLine), new Integer(result)));
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException(this.getMessage("commandLineException", this.getCommandlineInfo(commandLine)), (Exception)((Object)e));
        }
    }

    private String getExecutable() {
        String command = "jarsigner" + (Os.isFamily((String)"windows") ? ".exe" : "");
        String executable = this.findExecutable(command, System.getProperty("java.home"), new String[]{"../bin", "bin", "../sh"});
        if (executable == null) {
            try {
                Properties env = CommandLineUtils.getSystemEnvVars();
                String[] variables = new String[]{"JDK_HOME", "JAVA_HOME"};
                for (int i = 0; i < variables.length && executable == null; ++i) {
                    executable = this.findExecutable(command, env.getProperty(variables[i]), new String[]{"bin", "sh"});
                }
            }
            catch (IOException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().warn((CharSequence)("Failed to retrieve environment variables, cannot search for " + command), (Throwable)e);
                }
                this.getLog().warn((CharSequence)("Failed to retrieve environment variables, cannot search for " + command));
            }
        }
        if (executable == null) {
            executable = command;
        }
        return executable;
    }

    private String findExecutable(String command, String homeDir, String[] subDirs) {
        if (StringUtils.isNotEmpty((String)homeDir)) {
            for (int i = 0; i < subDirs.length; ++i) {
                File file = new File(new File(homeDir, subDirs[i]), command);
                if (!file.isFile()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private String getMessage(String key, Object[] args) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new MessageFormat(ResourceBundle.getBundle("jarsigner").getString(key)).format(args);
    }

    private String getMessage(String key) {
        return this.getMessage(key, null);
    }

    private String getMessage(String key, Object arg) {
        return this.getMessage(key, new Object[]{arg});
    }

    private String getMessage(String key, Object arg1, Object arg2) {
        return this.getMessage(key, new Object[]{arg1, arg2});
    }
}

