/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jarsigner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractJarsignerMojo
extends AbstractMojo {
    private boolean verbose;
    private String maxMemory;
    private File archive;
    private String[] arguments;
    private boolean skip;
    private boolean attachments;
    private MavenProject project;
    private String executable;

    public final void execute() throws MojoExecutionException {
        if (!this.skip) {
            this.executable = this.getExecutable();
            if (this.archive != null) {
                this.processArchive(this.archive);
            } else {
                this.processArtifact(this.project.getArtifact());
                Iterator it = this.project.getAttachedArtifacts().iterator();
                while (it.hasNext()) {
                    Artifact artifact = (Artifact)it.next();
                    if (this.attachments) {
                        this.processArtifact(artifact);
                        continue;
                    }
                    if (!this.isJarFile(artifact)) continue;
                    this.getLog().info((CharSequence)this.getMessage("ignoringAttachment", new Object[]{artifact.toString()}));
                }
            }
        } else {
            this.getLog().info((CharSequence)this.getMessage("disabled", null));
        }
    }

    protected abstract Commandline getCommandline(File var1, Commandline var2);

    protected String getCommandlineInfo(Commandline commandLine) {
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        return commandLine.toString();
    }

    private boolean isJarFile(Artifact artifact) {
        return artifact != null && artifact.getFile() != null && this.isJarFile(artifact.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isJarFile(File file) {
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
            try {
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    if (ze.getName().startsWith("META-INF/") || ze.getName().endsWith(".class")) {
                        boolean bl = true;
                        return bl;
                    }
                    ze = zis.getNextEntry();
                }
                return false;
            }
            finally {
                zis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void processArtifact(Artifact artifact) throws MojoExecutionException {
        if (artifact == null) {
            throw new NullPointerException("artifact");
        }
        if (this.isJarFile(artifact)) {
            if (this.verbose) {
                this.getLog().info((CharSequence)this.getMessage("processing", new Object[]{artifact.toString()}));
            } else if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)this.getMessage("processing", new Object[]{artifact.toString()}));
            }
            this.processArchive(artifact.getFile());
        } else if (this.verbose) {
            this.getLog().info((CharSequence)this.getMessage("unsupported", new Object[]{artifact.toString()}));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)this.getMessage("unsupported", new Object[]{artifact.toString()}));
        }
    }

    private void processArchive(File archive) throws MojoExecutionException {
        if (archive == null) {
            throw new NullPointerException("archive");
        }
        Commandline commandLine = new Commandline();
        commandLine.setExecutable(this.executable);
        commandLine.setWorkingDirectory(this.project.getBasedir());
        if (this.verbose) {
            commandLine.createArg().setValue("-verbose");
        }
        if (StringUtils.isNotEmpty((String)this.maxMemory)) {
            commandLine.createArg().setValue("-J-Xmx" + this.maxMemory);
        }
        if (this.arguments != null) {
            commandLine.addArguments(this.arguments);
        }
        commandLine = this.getCommandline(archive, commandLine);
        try {
            int result;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)this.getMessage("command", new Object[]{this.getCommandlineInfo(commandLine)}));
            }
            if ((result = CommandLineUtils.executeCommandLine((Commandline)commandLine, (InputStream)new InputStream(){

                public int read() {
                    return -1;
                }
            }, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String line) {
                    if (AbstractJarsignerMojo.this.verbose) {
                        AbstractJarsignerMojo.this.getLog().info((CharSequence)line);
                    } else {
                        AbstractJarsignerMojo.this.getLog().debug((CharSequence)line);
                    }
                }
            }, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String line) {
                    AbstractJarsignerMojo.this.getLog().warn((CharSequence)line);
                }
            })) != 0) {
                throw new MojoExecutionException(this.getMessage("failure", new Object[]{this.getCommandlineInfo(commandLine), new Integer(result)}));
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException(this.getMessage("commandLineException", new Object[]{this.getCommandlineInfo(commandLine)}), (Exception)((Object)e));
        }
    }

    private String getExecutable() {
        String command = "jarsigner" + (Os.isFamily((String)"windows") ? ".exe" : "");
        String executable = this.findExecutable(command, System.getProperty("java.home"), new String[]{"../bin", "bin", "../sh"});
        if (executable == null) {
            try {
                Properties env = CommandLineUtils.getSystemEnvVars();
                String[] variables = new String[]{"JDK_HOME", "JAVA_HOME"};
                for (int i = 0; i < variables.length && executable == null; ++i) {
                    executable = this.findExecutable(command, env.getProperty(variables[i]), new String[]{"bin", "sh"});
                }
            }
            catch (IOException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().warn((CharSequence)("Failed to retrieve environment variables, cannot search for " + command), (Throwable)e);
                }
                this.getLog().warn((CharSequence)("Failed to retrieve environment variables, cannot search for " + command));
            }
        }
        if (executable == null) {
            executable = command;
        }
        return executable;
    }

    private String findExecutable(String command, String homeDir, String[] subDirs) {
        if (StringUtils.isNotEmpty((String)homeDir)) {
            for (int i = 0; i < subDirs.length; ++i) {
                File file = new File(new File(homeDir, subDirs[i]), command);
                if (!file.isFile()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private String getMessage(String key, Object[] args) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new MessageFormat(ResourceBundle.getBundle("jarsigner").getString(key)).format(args);
    }
}

