/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.util.Iterator;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzeReportView {
    public void generateReport(ProjectDependencyAnalysis analysis, Sink sink, ResourceBundle bundle) {
        Iterator<Object> iter;
        sink.head();
        sink.title();
        sink.text(bundle.getString("analyze.report.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("analyze.report.mainTitle"));
        sink.sectionTitle1_();
        sink.section2();
        sink.sectionTitle2();
        sink.text(bundle.getString("analyze.report.UsedDeclaredDependencies"));
        sink.sectionTitle2_();
        if (analysis.getUsedDeclaredArtifacts().isEmpty()) {
            sink.paragraph();
            sink.text(bundle.getString("analyze.report.noDependency"));
            sink.paragraph_();
            sink.horizontalRule();
        } else {
            iter = analysis.getUsedDeclaredArtifacts().iterator();
            this.generateDependenciesTable(sink, iter);
        }
        sink.section2_();
        sink.section2();
        sink.sectionTitle2();
        sink.text(bundle.getString("analyze.report.UsedUndeclaredDependencies"));
        sink.sectionTitle2_();
        if (analysis.getUsedUndeclaredArtifacts().isEmpty()) {
            sink.paragraph();
            sink.text(bundle.getString("analyze.report.noDependency"));
            sink.paragraph_();
            sink.horizontalRule();
        } else {
            iter = analysis.getUsedUndeclaredArtifacts().iterator();
            this.generateDependenciesTable(sink, iter);
        }
        sink.section2_();
        sink.section2();
        sink.sectionTitle2();
        sink.text(bundle.getString("analyze.report.UnusedDeclaredDependencies"));
        sink.sectionTitle2_();
        if (analysis.getUnusedDeclaredArtifacts().isEmpty()) {
            sink.paragraph();
            sink.text(bundle.getString("analyze.report.noDependency"));
            sink.paragraph_();
            sink.horizontalRule();
        } else {
            iter = analysis.getUnusedDeclaredArtifacts().iterator();
            this.generateDependenciesTable(sink, iter);
        }
        sink.section2_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    public void generateDependenciesTable(Sink sink, Iterator<Artifact> iter) {
        sink.table();
        sink.tableRow();
        sink.tableCell();
        sink.bold();
        sink.text("GroupId");
        sink.bold_();
        sink.tableCell_();
        sink.tableCell();
        sink.bold();
        sink.text("ArtifactId");
        sink.bold_();
        sink.tableCell_();
        sink.tableCell();
        sink.bold();
        sink.text("Version");
        sink.bold_();
        sink.tableCell_();
        sink.tableCell();
        sink.bold();
        sink.text("Scope");
        sink.bold_();
        sink.tableCell_();
        sink.tableCell();
        sink.bold();
        sink.text("Classifier");
        sink.bold_();
        sink.tableCell_();
        sink.tableCell();
        sink.bold();
        sink.text("Type");
        sink.bold_();
        sink.tableCell_();
        sink.tableCell();
        sink.bold();
        sink.text("Optional");
        sink.bold_();
        sink.tableCell_();
        sink.tableRow_();
        while (iter.hasNext()) {
            Artifact artifact = iter.next();
            sink.tableRow();
            sink.tableCell();
            sink.text(artifact.getGroupId());
            sink.tableCell_();
            sink.tableCell();
            sink.text(artifact.getArtifactId());
            sink.tableCell_();
            sink.tableCell();
            sink.text(artifact.getVersion());
            sink.tableCell_();
            sink.tableCell();
            sink.text(artifact.getScope());
            sink.tableCell_();
            sink.tableCell();
            sink.text(artifact.getClassifier());
            sink.tableCell_();
            sink.tableCell();
            sink.text(artifact.getType());
            sink.tableCell_();
            sink.tableCell();
            if (artifact.isOptional()) {
                sink.text("");
            } else {
                sink.text("false");
            }
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.table_();
        sink.horizontalRule();
    }
}

