/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractFromDependenciesMojo;
import org.apache.maven.plugin.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.DestFileFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

public class CopyDependenciesMojo
extends AbstractFromDependenciesMojo {
    public void execute() throws MojoExecutionException {
        DependencyStatusSets dss = this.getDependencySets(this.failOnMissingClassifierArtifact);
        Set artifacts = dss.getResolvedDependencies();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            this.copyArtifact((Artifact)i.next(), this.stripVersion);
        }
        artifacts = dss.getSkippedDependencies();
        i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.getLog().info((CharSequence)(artifact.getFile().getName() + " already exists in destination."));
        }
    }

    protected void copyArtifact(Artifact artifact, boolean removeVersion) throws MojoExecutionException {
        String destFileName = DependencyUtil.getFormattedFileName(artifact, removeVersion);
        File destDir = DependencyUtil.getFormattedOutputDirectory(this.useSubDirectoryPerType, this.useSubDirectoryPerArtifact, this.useRepositoryLayout, this.stripVersion, this.outputDirectory, artifact);
        File destFile = new File(destDir, destFileName);
        this.copyFile(artifact.getFile(), destFile);
        if (this.isCopyPom()) {
            Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
            try {
                this.resolver.resolve(pomArtifact, this.remoteRepos, this.local);
            }
            catch (Exception e) {
                this.getLog().info((CharSequence)e.getMessage());
            }
            if (pomArtifact.getFile() != null && pomArtifact.getFile().exists()) {
                File pomDestFile = new File(destDir, DependencyUtil.getFormattedFileName(pomArtifact, removeVersion));
                this.copyFile(pomArtifact.getFile(), pomDestFile);
            }
        }
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new DestFileFilter(this.overWriteReleases, this.overWriteSnapshots, this.overWriteIfNewer, this.useSubDirectoryPerArtifact, this.useSubDirectoryPerType, this.useRepositoryLayout, this.stripVersion, this.outputDirectory);
    }
}

