/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.changes.AbstractChangesReport;
import org.apache.maven.plugin.changes.ChangesReportGenerator;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public class ChangesMojo
extends AbstractChangesReport {
    private File xmlPath;
    private String issueLinkTemplate;
    private Map issueLinkTemplatePerSystem;
    private String url;
    private boolean addActionDate;
    private MavenFileFilter mavenFileFilter;
    protected MavenSession session;
    private boolean filteringChanges;
    private File filteredOutputDirectory;
    private String publishDateFormat;
    private String publishDateLocale;

    public boolean canGenerateReport() {
        return this.xmlPath.isFile();
    }

    private void copyStaticResources() throws MavenReportException {
        String pluginResourcesBase = "org/apache/maven/plugin/changes";
        String[] resourceNames = new String[]{"images/add.gif", "images/fix.gif", "images/icon_help_sml.gif", "images/remove.gif", "images/rss.png", "images/update.gif"};
        try {
            this.getLog().debug((CharSequence)"Copying static resources.");
            for (int i = 0; i < resourceNames.length; ++i) {
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/apache/maven/plugin/changes/" + resourceNames[i]);
                FileUtils.copyURLToFile((URL)url, (File)new File(this.getReportOutputDirectory(), resourceNames[i]));
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy static resources.");
        }
    }

    public void executeReport(Locale locale) throws MavenReportException {
        if (!this.xmlPath.exists()) {
            this.getLog().warn((CharSequence)("changes.xml file " + this.xmlPath.getAbsolutePath() + " does not exist."));
            return;
        }
        if (this.filteringChanges) {
            if (!this.filteredOutputDirectory.exists()) {
                this.filteredOutputDirectory.mkdirs();
            }
            XmlStreamReader xmlStreamReader = null;
            try {
                xmlStreamReader = ReaderFactory.newXmlReader((File)this.xmlPath);
                String encoding = xmlStreamReader.getEncoding();
                File resultFile = new File(this.filteredOutputDirectory, "changes.xml");
                Date now = new Date();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.publishDateFormat, new Locale(this.publishDateLocale));
                Properties additionnalProperties = new Properties();
                additionnalProperties.put("publishDate", simpleDateFormat.format(now));
                MavenFileFilterRequest mavenFileFilterRequest = new MavenFileFilterRequest(this.xmlPath, resultFile, true, this.project, Collections.EMPTY_LIST, false, encoding, this.session, additionnalProperties);
                this.mavenFileFilter.copyFile(mavenFileFilterRequest);
                this.xmlPath = resultFile;
            }
            catch (IOException e) {
                throw new MavenReportException("Exception during filtering changes file : " + e.getMessage(), (Exception)e);
            }
            catch (MavenFilteringException e) {
                throw new MavenReportException("Exception during filtering changes file : " + e.getMessage(), (Exception)((Object)e));
            }
            finally {
                if (xmlStreamReader != null) {
                    IOUtil.close((Reader)xmlStreamReader);
                }
            }
        }
        ChangesReportGenerator report = new ChangesReportGenerator(this.xmlPath, this.getLog());
        report.setIssueLinksPerSystem(this.issueLinkTemplatePerSystem);
        report.setIssueLink(this.issueLinkTemplate);
        report.setUrl(this.url);
        report.setAddActionDate(this.addActionDate);
        if (!report.canGenerateIssueLinks()) {
            this.getLog().warn((CharSequence)"No issue management URL defined in POM. Links to your issues will not work correctly.");
        }
        report.doGenerateReport(this.getBundle(locale), this.getSink());
        this.copyStaticResources();
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.changes.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.changes.description");
    }

    public String getOutputName() {
        return "changes-report";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("changes-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

