/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.announcement;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.announcement.AbstractAnnouncementMojo;
import org.apache.maven.plugin.announcement.MailSender;
import org.apache.maven.plugin.announcement.mailsender.ProjectJavamailMailSender;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.mailsender.MailMessage;
import org.codehaus.plexus.mailsender.MailSenderException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="announcement-mail", threadSafe=true)
@Execute(goal="announcement-generate")
public class AnnouncementMailMojo
extends AbstractAnnouncementMojo {
    @Parameter(property="project.developers", required=true, readonly=true)
    private List from;
    @Parameter(property="changes.fromDeveloperId")
    private String fromDeveloperId;
    @Parameter(defaultValue="text/plain", required=true)
    private String mailContentType;
    @Parameter(property="changes.mailSender")
    private MailSender mailSender;
    @Parameter(property="changes.sender")
    private String senderString;
    @Parameter(property="changes.password")
    private String password;
    @Component
    private MavenProject project;
    @Parameter(property="changes.smtpHost", required=true)
    private String smtpHost;
    @Parameter(property="changes.smtpPort", defaultValue="25", required=true)
    private int smtpPort;
    @Parameter(property="changes.sslMode", defaultValue="false")
    private boolean sslMode;
    @Parameter(property="changes.startTls", defaultValue="false")
    private boolean startTls;
    @Parameter(property="changes.subject", defaultValue="[ANNOUNCEMENT] - ${project.name} ${project.version} released", required=true)
    private String subject;
    @Parameter(property="changes.announcementFile", defaultValue="announcement.vm", required=true)
    private String announcementFile;
    @Parameter(defaultValue="${project.build.directory}/announcement", required=true)
    private File announcementDirectory;
    @Parameter(property="changes.templateEncoding", defaultValue="${project.build.sourceEncoding}")
    private String templateEncoding;
    @Parameter
    private File templateOutputDirectory;
    @Parameter(required=true)
    private List toAddresses;
    @Parameter
    private List ccAddresses;
    @Parameter
    private List bccAddresses;
    @Parameter(property="changes.username")
    private String username;
    private ProjectJavamailMailSender mailer = new ProjectJavamailMailSender();

    public void execute() throws MojoExecutionException {
        if (this.templateOutputDirectory != null) {
            throw new MojoExecutionException("You are using the old parameter 'templateOutputDirectory'. You must use 'announcementDirectory' instead.");
        }
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the announcement mail in this project because it's not the Execution Root");
        } else {
            File file = new File(this.announcementDirectory, this.announcementFile);
            ConsoleLogger logger = new ConsoleLogger(1, "base");
            if (this.getLog().isDebugEnabled()) {
                logger.setThreshold(0);
            }
            this.mailer.enableLogging((Logger)logger);
            this.mailer.setSmtpHost(this.getSmtpHost());
            this.mailer.setSmtpPort(this.getSmtpPort());
            this.mailer.setSslMode(this.sslMode, this.startTls);
            if (this.username != null) {
                this.mailer.setUsername(this.username);
            }
            if (this.password != null) {
                this.mailer.setPassword(this.password);
            }
            this.mailer.initialize();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("fromDeveloperId: " + this.getFromDeveloperId()));
            }
            if (file.isFile()) {
                this.getLog().info((CharSequence)("Connecting to Host: " + this.getSmtpHost() + ":" + this.getSmtpPort()));
                this.sendMessage();
            } else {
                throw new MojoExecutionException("Announcement file " + file + " not found...");
            }
        }
    }

    protected void sendMessage() throws MojoExecutionException {
        File file = new File(this.announcementDirectory, this.announcementFile);
        String email = "";
        MailSender ms = this.getActualMailSender();
        String fromName = ms.getName();
        String fromAddress = ms.getEmail();
        if (fromAddress == null || fromAddress.equals("")) {
            throw new MojoExecutionException("Invalid mail sender: name and email is mandatory (" + ms + ").");
        }
        this.getLog().info((CharSequence)("Using this sender for email announcement: " + fromAddress + " < " + fromName + " > "));
        try {
            MailMessage mailMsg = new MailMessage();
            mailMsg.setSubject(this.getSubject());
            mailMsg.setContent(this.readAnnouncement(file));
            mailMsg.setContentType(this.mailContentType);
            mailMsg.setFrom(fromAddress, fromName);
            for (Object o1 : this.getToAddresses()) {
                email = o1.toString();
                this.getLog().info((CharSequence)("Sending mail to " + email + "..."));
                mailMsg.addTo(email, "");
            }
            if (this.getCcAddresses() != null) {
                for (Object o : this.getCcAddresses()) {
                    email = o.toString();
                    this.getLog().info((CharSequence)("Sending cc mail to " + email + "..."));
                    mailMsg.addCc(email, "");
                }
            }
            if (this.getBccAddresses() != null) {
                for (Object o : this.getBccAddresses()) {
                    email = o.toString();
                    this.getLog().info((CharSequence)("Sending bcc mail to " + email + "..."));
                    mailMsg.addBcc(email, "");
                }
            }
            this.mailer.send(mailMsg);
            this.getLog().info((CharSequence)"Sent...");
        }
        catch (MailSenderException e) {
            throw new MojoExecutionException("Failed to send email < " + email + " >", (Exception)((Object)e));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readAnnouncement(File file) throws MojoExecutionException {
        String string;
        InputStreamReader reader = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            if (StringUtils.isEmpty((String)this.templateEncoding)) {
                this.templateEncoding = ReaderFactory.FILE_ENCODING;
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding '" + this.templateEncoding + "', i.e. build is platform dependent!"));
            }
            reader = new InputStreamReader((InputStream)inputStream, this.templateEncoding);
            string = IOUtil.toString((Reader)reader);
        }
        catch (FileNotFoundException fnfe) {
            try {
                throw new MojoExecutionException("File not found. " + file);
                catch (UnsupportedEncodingException uee) {
                    throw new MojoExecutionException("Unsupported encoding: '" + this.templateEncoding + "'");
                }
                catch (IOException ioe) {
                    throw new MojoExecutionException("Failed to read the announcement file.", (Exception)ioe);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(inputStream);
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)inputStream);
        IOUtil.close((Reader)reader);
        return string;
    }

    protected MailSender getActualMailSender() throws MojoExecutionException {
        if (this.senderString != null) {
            try {
                InternetAddress ia = new InternetAddress(this.senderString, true);
                return new MailSender(ia.getPersonal(), ia.getAddress());
            }
            catch (AddressException e) {
                throw new MojoExecutionException("Invalid value for change.sender: ", (Exception)((Object)e));
            }
        }
        if (this.mailSender != null && this.mailSender.getEmail() != null) {
            return this.mailSender;
        }
        if (this.from == null || this.from.isEmpty()) {
            throw new MojoExecutionException("The <developers> section in your pom should not be empty. Add a <developer> entry or set the mailSender parameter.");
        }
        if (this.fromDeveloperId == null) {
            Developer dev = (Developer)this.from.get(0);
            return new MailSender(dev.getName(), dev.getEmail());
        }
        for (Object aFrom : this.from) {
            Developer developer = (Developer)aFrom;
            if (!this.fromDeveloperId.equals(developer.getId())) continue;
            return new MailSender(developer.getName(), developer.getEmail());
        }
        throw new MojoExecutionException("Missing developer with id '" + this.fromDeveloperId + "' in the <developers> section in your pom.");
    }

    public List getBccAddresses() {
        return this.bccAddresses;
    }

    public void setBccAddresses(List bccAddresses) {
        this.bccAddresses = bccAddresses;
    }

    public List getCcAddresses() {
        return this.ccAddresses;
    }

    public void setCcAddresses(List ccAddresses) {
        this.ccAddresses = ccAddresses;
    }

    public List getFrom() {
        return this.from;
    }

    public void setFrom(List from) {
        this.from = from;
    }

    public String getFromDeveloperId() {
        return this.fromDeveloperId;
    }

    public void setFromDeveloperId(String fromDeveloperId) {
        this.fromDeveloperId = fromDeveloperId;
    }

    public MailSender getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public boolean isSslMode() {
        return this.sslMode;
    }

    public void setSslMode(boolean sslMode) {
        this.sslMode = sslMode;
    }

    public boolean isStartTls() {
        return this.startTls;
    }

    public void setStartTls(boolean startTls) {
        this.startTls = startTls;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getAnnouncementFile() {
        return this.announcementFile;
    }

    public void setAnnouncementFile(String announcementFile) {
        this.announcementFile = announcementFile;
    }

    public File getAnnouncementDirectory() {
        return this.announcementDirectory;
    }

    public void setAnnouncementDirectory(File announcementDirectory) {
        this.announcementDirectory = announcementDirectory;
    }

    public List getToAddresses() {
        return this.toAddresses;
    }

    public void setToAddresses(List toAddresses) {
        this.toAddresses = toAddresses;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

