/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.artifact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.phase.ModuleSetAssemblyPhase;
import org.apache.maven.plugin.assembly.artifact.DependencyResolutionException;
import org.apache.maven.plugin.assembly.artifact.DependencyResolver;
import org.apache.maven.plugin.assembly.artifact.ResolutionManagementInfo;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.ModuleBinaries;
import org.apache.maven.plugin.assembly.model.ModuleSet;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.resolved.AssemblyId;
import org.apache.maven.plugin.assembly.utils.FilterUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

@Component(role=DependencyResolver.class)
public class DefaultDependencyResolver
extends AbstractLogEnabled
implements DependencyResolver {
    @Requirement
    private ArtifactResolver resolver;
    @Requirement
    private ArtifactMetadataSource metadataSource;
    @Requirement
    private ArtifactFactory factory;

    public DefaultDependencyResolver() {
    }

    protected DefaultDependencyResolver(ArtifactResolver resolver, ArtifactMetadataSource metadataSource, ArtifactFactory factory, Logger logger) {
        this.resolver = resolver;
        this.metadataSource = metadataSource;
        this.factory = factory;
        this.enableLogging(logger);
    }

    @Override
    public Map<DependencySet, Set<Artifact>> resolveDependencySets(Assembly assembly, ModuleSet moduleSet, AssemblerConfigurationSource configSource, List<DependencySet> dependencySets) throws DependencyResolutionException {
        LinkedHashMap<DependencySet, Set<Artifact>> result = new LinkedHashMap<DependencySet, Set<Artifact>>();
        for (DependencySet dependencySet : dependencySets) {
            Set<Object> artifacts;
            MavenProject currentProject = configSource.getProject();
            ResolutionManagementInfo info = new ResolutionManagementInfo(currentProject);
            this.updateRepositoryResolutionRequirements(assembly, info);
            AssemblyId assemblyId = AssemblyId.createAssemblyId(assembly);
            this.updateDependencySetResolutionRequirements(dependencySet, info, assemblyId, currentProject);
            this.updateModuleSetResolutionRequirements(assemblyId, moduleSet, dependencySet, info, configSource);
            if (info.isResolutionRequired()) {
                List<ArtifactRepository> repos = this.aggregateRemoteArtifactRepositories(configSource.getRemoteRepositories(), info.getEnabledProjects());
                artifacts = info.getArtifacts();
                if (info.isResolvedTransitively()) {
                    this.getLogger().debug("Resolving project dependencies transitively.");
                    artifacts = this.resolveTransitively(artifacts, repos, info, configSource);
                } else {
                    this.getLogger().debug("Resolving project dependencies ONLY. Transitive dependencies WILL NOT be included in the results.");
                    artifacts = this.resolveNonTransitively(assembly, artifacts, configSource, repos);
                }
            } else {
                artifacts = new HashSet();
            }
            result.put(dependencySet, artifacts);
        }
        return result;
    }

    @Override
    public Map<DependencySet, Set<Artifact>> resolveDependencySets(Assembly assembly, AssemblerConfigurationSource configSource, List<DependencySet> dependencySets) throws DependencyResolutionException {
        LinkedHashMap<DependencySet, Set<Artifact>> result = new LinkedHashMap<DependencySet, Set<Artifact>>();
        for (DependencySet dependencySet : dependencySets) {
            Set<Object> artifacts;
            MavenProject currentProject = configSource.getProject();
            ResolutionManagementInfo info = new ResolutionManagementInfo(currentProject);
            this.updateRepositoryResolutionRequirements(assembly, info);
            AssemblyId assemblyId = AssemblyId.createAssemblyId(assembly);
            this.updateDependencySetResolutionRequirements(dependencySet, info, assemblyId, currentProject);
            if (info.isResolutionRequired()) {
                List<ArtifactRepository> repos = this.aggregateRemoteArtifactRepositories(configSource.getRemoteRepositories(), info.getEnabledProjects());
                artifacts = info.getArtifacts();
                if (info.isResolvedTransitively()) {
                    this.getLogger().debug("Resolving project dependencies transitively.");
                    artifacts = this.resolveTransitively(artifacts, repos, info, configSource);
                } else {
                    this.getLogger().debug("Resolving project dependencies ONLY. Transitive dependencies WILL NOT be included in the results.");
                    artifacts = this.resolveNonTransitively(assembly, artifacts, configSource, repos);
                }
            } else {
                artifacts = new HashSet();
            }
            result.put(dependencySet, artifacts);
        }
        return result;
    }

    Set<Artifact> resolveNonTransitively(Assembly assembly, Set<Artifact> dependencyArtifacts, AssemblerConfigurationSource configSource, List<ArtifactRepository> repos) throws DependencyResolutionException {
        ArrayList<Artifact> missing = new ArrayList<Artifact>();
        LinkedHashSet<Artifact> resolved = new LinkedHashSet<Artifact>();
        for (Artifact depArtifact : dependencyArtifacts) {
            try {
                this.resolver.resolve(depArtifact, repos, configSource.getLocalRepository());
                resolved.add(depArtifact);
            }
            catch (ArtifactResolutionException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Failed to resolve: " + depArtifact.getId() + " for assembly: " + assembly.getId());
                }
                missing.add(depArtifact);
            }
            catch (ArtifactNotFoundException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Failed to resolve: " + depArtifact.getId() + " for assembly: " + assembly.getId());
                }
                missing.add(depArtifact);
            }
        }
        if (!missing.isEmpty()) {
            MavenProject project = configSource.getProject();
            Artifact rootArtifact = project.getArtifact();
            MultipleArtifactsNotFoundException error = new MultipleArtifactsNotFoundException(rootArtifact, new ArrayList<Artifact>(resolved), missing, repos);
            throw new DependencyResolutionException("Failed to resolve dependencies for: " + assembly.getId(), (Throwable)error);
        }
        return resolved;
    }

    private Set<Artifact> resolveTransitively(Set<Artifact> dependencyArtifacts, List<ArtifactRepository> repos, ResolutionManagementInfo info, AssemblerConfigurationSource configSource) throws DependencyResolutionException {
        ArtifactResolutionResult result;
        MavenProject project = configSource.getProject();
        ScopeArtifactFilter filter = info.getScopeFilter();
        ArtifactRepository localRepository = configSource.getLocalRepository();
        try {
            result = this.resolver.resolveTransitively(dependencyArtifacts, project.getArtifact(), project.getManagedVersionMap(), localRepository, repos, this.metadataSource, (ArtifactFilter)filter);
        }
        catch (ArtifactResolutionException e) {
            throw new DependencyResolutionException("Failed to resolve dependencies for assembly: ", e);
        }
        catch (ArtifactNotFoundException e) {
            throw new DependencyResolutionException("Failed to resolve dependencies for assembly: ", e);
        }
        this.getLogger().debug("While resolving dependencies of " + project.getId() + ":");
        FilterUtils.reportFilteringStatistics(Collections.singleton(filter), this.getLogger());
        return result.getArtifacts();
    }

    void updateRepositoryResolutionRequirements(Assembly assembly, ResolutionManagementInfo requirements) {
        List<Repository> repositories = assembly.getRepositories();
        if (repositories != null && !repositories.isEmpty()) {
            requirements.setResolutionRequired(true);
            for (Repository repo : repositories) {
                this.enableScope(repo.getScope(), requirements);
            }
        }
    }

    void updateModuleSetResolutionRequirements(AssemblyId assemblyId, ModuleSet set, DependencySet dependencySet, ResolutionManagementInfo requirements, AssemblerConfigurationSource configSource) throws DependencyResolutionException {
        ModuleBinaries binaries = set.getBinaries();
        if (binaries != null) {
            Set<MavenProject> projects;
            try {
                projects = ModuleSetAssemblyPhase.getModuleProjects(set, configSource, this.getLogger());
            }
            catch (ArchiveCreationException e) {
                throw new DependencyResolutionException("Error determining project-set for moduleSet with binaries.", e);
            }
            if (!projects.isEmpty()) {
                for (MavenProject p : projects) {
                    requirements.enableProjectResolution(p);
                    if (p.getArtifact() != null) continue;
                    Artifact artifact = this.factory.createBuildArtifact(p.getGroupId(), p.getArtifactId(), p.getVersion(), p.getPackaging());
                    p.setArtifact(artifact);
                }
            }
            if (binaries.isIncludeDependencies()) {
                this.updateDependencySetResolutionRequirements(dependencySet, requirements, assemblyId, projects.toArray(new MavenProject[projects.size()]));
            }
        }
    }

    void updateDependencySetResolutionRequirements(DependencySet set, ResolutionManagementInfo requirements, AssemblyId assemblyId, MavenProject ... projects) throws DependencyResolutionException {
        requirements.setResolutionRequired(true);
        requirements.setResolvedTransitively(set.isUseTransitiveDependencies());
        this.enableScope(set.getScope(), requirements);
        for (MavenProject project : projects) {
            if (project == null) continue;
            Set dependencyArtifacts = project.getDependencyArtifacts();
            if (dependencyArtifacts == null) {
                try {
                    dependencyArtifacts = project.createArtifacts(this.factory, null, (ArtifactFilter)requirements.getScopeFilter());
                    project.setDependencyArtifacts(dependencyArtifacts);
                }
                catch (InvalidDependencyVersionException e) {
                    throw new DependencyResolutionException("Failed to create dependency artifacts for resolution. Assembly: " + assemblyId, e);
                }
            }
            requirements.addArtifacts(dependencyArtifacts);
            this.getLogger().debug("Dependencies for project: " + project.getId() + " are:\n" + StringUtils.join(dependencyArtifacts.iterator(), (String)"\n"));
        }
    }

    private void enableScope(String scope, ResolutionManagementInfo requirements) {
        if ("compile".equals(scope)) {
            requirements.enableCompileScope();
        } else if ("provided".equals(scope)) {
            requirements.enableProvidedScope();
        } else if ("runtime".equals(scope)) {
            requirements.enableRuntimeScope();
        } else if ("system".equals(scope)) {
            requirements.enableSystemScope();
        } else if ("test".equals(scope)) {
            requirements.enableTestScope();
        }
    }

    List<ArtifactRepository> aggregateRemoteArtifactRepositories(List<ArtifactRepository> remoteRepositories, Set<MavenProject> projects) {
        ArrayList<List> repoLists = new ArrayList<List>();
        repoLists.add(remoteRepositories);
        for (MavenProject project : projects) {
            repoLists.add(project.getRemoteArtifactRepositories());
        }
        ArrayList<ArtifactRepository> remoteRepos = new ArrayList<ArtifactRepository>();
        HashSet<String> encounteredUrls = new HashSet<String>();
        for (List repositoryList : repoLists) {
            if (repositoryList == null || repositoryList.isEmpty()) continue;
            for (ArtifactRepository repo : repositoryList) {
                if (encounteredUrls.contains(repo.getUrl())) continue;
                remoteRepos.add(repo);
                encounteredUrls.add(repo.getUrl());
            }
        }
        return remoteRepos;
    }
}

