/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.scanner;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class DefaultMojoScanner
extends AbstractLogEnabled
implements MojoScanner {
    private Map mojoDescriptorExtractors;
    private Set activeExtractors;

    public DefaultMojoScanner(Map extractors) {
        this.mojoDescriptorExtractors = extractors;
        this.enableLogging((Logger)new ConsoleLogger(1, "standalone-scanner-logger"));
    }

    public DefaultMojoScanner() {
    }

    public void populatePluginDescriptor(MavenProject project, PluginDescriptor pluginDescriptor) throws ExtractionException, InvalidPluginDescriptorException {
        Logger logger = this.getLogger();
        Set activeExtractors = this.getActiveExtractors();
        logger.info("Using " + activeExtractors.size() + " extractors.");
        int numMojoDescriptors = 0;
        Iterator it = activeExtractors.iterator();
        while (it.hasNext()) {
            String language = (String)it.next();
            MojoDescriptorExtractor extractor = (MojoDescriptorExtractor)this.mojoDescriptorExtractors.get(language);
            if (extractor == null) {
                throw new ExtractionException("No extractor for language: " + language);
            }
            logger.info("Applying extractor for language: " + language);
            List extractorDescriptors = extractor.execute(project, pluginDescriptor);
            logger.info("Extractor for language: " + language + " found " + extractorDescriptors.size() + " mojo descriptors.");
            numMojoDescriptors += extractorDescriptors.size();
            Iterator descriptorIt = extractorDescriptors.iterator();
            while (descriptorIt.hasNext()) {
                MojoDescriptor descriptor = (MojoDescriptor)descriptorIt.next();
                logger.debug("Adding mojo: " + descriptor + " to plugin descriptor.");
                descriptor.setPluginDescriptor(pluginDescriptor);
                pluginDescriptor.addMojo(descriptor);
            }
        }
        if (numMojoDescriptors == 0) {
            int i;
            for (i = 0; i < 10; ++i) {
                logger.warn("");
            }
            logger.warn("*******************************************************");
            logger.warn("Deprecation Alert:");
            logger.warn("No mojo descriptors were found in this project which has a packaging type of maven-plugin.");
            logger.warn("In future versions of the plugin tools, this will fail the build.");
            logger.warn("If this project is an archetype, change the packaging type from maven-plugin to maven-archetype.");
            logger.warn("********************************************************");
            for (i = 0; i < 10; ++i) {
                logger.warn("");
            }
        }
    }

    protected Set getActiveExtractors() {
        HashSet result = this.activeExtractors;
        if (result == null) {
            result = new HashSet(this.mojoDescriptorExtractors.keySet());
        }
        return result;
    }

    public void setActiveExtractors(Set extractors) {
        if (extractors == null) {
            this.activeExtractors = null;
        } else {
            this.activeExtractors = new HashSet();
            Iterator i = extractors.iterator();
            while (i.hasNext()) {
                String extractor = (String)i.next();
                if (extractor == null || extractor.length() <= 0) continue;
                this.activeExtractors.add(extractor);
            }
        }
    }
}

