/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.annotations.converter;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.tools.plugin.extractor.annotations.converter.ConverterContext;
import org.apache.maven.tools.plugin.extractor.annotations.converter.tag.JavadocTagToHtmlConverter;
import org.apache.maven.tools.plugin.extractor.annotations.converter.tag.inline.JavadocInlineTagToHtmlConverter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class JavadocInlineTagsToXhtmlConverter {
    private static final Logger LOG = LoggerFactory.getLogger(JavadocInlineTagsToXhtmlConverter.class);
    private final Map<String, JavadocInlineTagToHtmlConverter> converters;
    private static final Pattern INLINE_TAG_PATTERN = Pattern.compile("\\{@([^\\s]*)(?:\\s([^\\}]*))?\\}");
    private static final int GROUP_TAG_NAME = 1;
    private static final int GROUP_REFERENCE = 2;

    @Inject
    public JavadocInlineTagsToXhtmlConverter(Map<String, JavadocInlineTagToHtmlConverter> converters) {
        this.converters = converters;
    }

    public String convert(String text, ConverterContext context) {
        Matcher matcher = INLINE_TAG_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String patternReplacement;
            String tagName = matcher.group(1);
            JavadocTagToHtmlConverter converter = this.converters.get(tagName);
            if (converter == null) {
                patternReplacement = matcher.group(0) + "<!-- unsupported tag '" + tagName + "' -->";
                LOG.warn("Found unsupported javadoc inline tag '{}' in {}", (Object)tagName, (Object)context.getLocation());
            } else {
                try {
                    patternReplacement = converter.convert(matcher.group(2), context);
                }
                catch (Throwable t) {
                    patternReplacement = matcher.group(0) + "<!-- error processing javadoc tag '" + tagName + "': " + t.getMessage() + " -->";
                    LOG.warn("Error converting javadoc inline tag '{}' in {}", new Object[]{tagName, context.getLocation(), t});
                }
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(patternReplacement));
        }
        matcher.appendTail(sb);
        return JavadocInlineTagsToXhtmlConverter.toXHTML(sb.toString());
    }

    static String toXHTML(String bodySnippet) {
        String html = "<html><head></head><body>" + bodySnippet + "</body>";
        Document document = Jsoup.parse((String)html);
        document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        return document.body().html();
    }
}

