/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.maven.mercury.artifact.version.VersionComparator;
import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.repository.metadata.MetadataOperation;
import org.apache.maven.mercury.repository.metadata.StringOperand;
import org.apache.maven.mercury.repository.metadata.Versioning;
import org.apache.maven.mercury.util.TimeUtil;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddVersionOperation
implements MetadataOperation {
    private static final Language LANG = new DefaultLanguage(AddVersionOperation.class);
    private String version;

    public AddVersionOperation(StringOperand data) throws MetadataException {
        this.setOperand(data);
    }

    @Override
    public void setOperand(Object data) throws MetadataException {
        if (data == null || !(data instanceof StringOperand)) {
            throw new MetadataException(LANG.getMessage("bad.operand", new String[]{"StringOperand", data == null ? "null" : data.getClass().getName()}));
        }
        this.version = ((StringOperand)data).getOperand();
    }

    @Override
    public boolean perform(Metadata metadata) throws MetadataException {
        List vl;
        if (metadata == null) {
            return false;
        }
        Versioning vs = metadata.getVersioning();
        if (vs == null) {
            vs = new Versioning();
            metadata.setVersioning(vs);
        }
        if (vs.getVersions() != null && vs.getVersions().size() > 0 && (vl = vs.getVersions()).contains(this.version)) {
            return false;
        }
        vs.addVersion(this.version);
        List versions = vs.getVersions();
        Collections.sort(versions, new VersionComparator());
        vs.setLatest(this.getLatestVersion(versions));
        vs.setRelease(this.getReleaseVersion(versions));
        vs.setLastUpdated(TimeUtil.getUTCTimestamp());
        return true;
    }

    private String getLatestVersion(List<String> orderedVersions) {
        return orderedVersions.get(orderedVersions.size() - 1);
    }

    private String getReleaseVersion(List<String> orderedVersions) {
        for (int i = orderedVersions.size() - 1; i >= 0; --i) {
            if (orderedVersions.get(i).endsWith("SNAPSHOT")) continue;
            return orderedVersions.get(i);
        }
        return "";
    }
}

