/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.builder.ProjectUri;
import org.apache.maven.shared.model.ModelContainer;
import org.apache.maven.shared.model.ModelContainerAction;
import org.apache.maven.shared.model.ModelContainerFactory;
import org.apache.maven.shared.model.ModelProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginReportSetIdModelContainerFactory
implements ModelContainerFactory {
    private static final Collection<String> uris = Collections.unmodifiableList(Arrays.asList(ProjectUri.Reporting.Plugins.Plugin.ReportSets.ReportSet.xUri));

    public Collection<String> getUris() {
        return uris;
    }

    public ModelContainer create(List<ModelProperty> modelProperties) {
        if (modelProperties == null || modelProperties.size() == 0) {
            throw new IllegalArgumentException("modelProperties: null or empty");
        }
        return new PluginReportSetIdModelContainer(modelProperties);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PluginReportSetIdModelContainer
    implements ModelContainer {
        private String id;
        private List<ModelProperty> properties;

        private PluginReportSetIdModelContainer(List<ModelProperty> properties) {
            this.properties = new ArrayList<ModelProperty>(properties);
            this.properties = Collections.unmodifiableList(this.properties);
            for (ModelProperty mp : properties) {
                if (!mp.getUri().endsWith("/id")) continue;
                this.id = mp.getResolvedValue();
            }
        }

        public ModelContainerAction containerAction(ModelContainer modelContainer) {
            if (modelContainer == null) {
                throw new IllegalArgumentException("modelContainer: null");
            }
            if (!(modelContainer instanceof PluginReportSetIdModelContainer)) {
                throw new IllegalArgumentException("modelContainer: wrong type");
            }
            PluginReportSetIdModelContainer c = (PluginReportSetIdModelContainer)modelContainer;
            if (c.id == null || this.id == null) {
                return ModelContainerAction.NOP;
            }
            return c.id.equals(this.id) ? ModelContainerAction.JOIN : ModelContainerAction.NOP;
        }

        public ModelContainer createNewInstance(List<ModelProperty> modelProperties) {
            return new PluginReportSetIdModelContainer(modelProperties);
        }

        public List<ModelProperty> getProperties() {
            return this.properties;
        }

        public String toString() {
            return "ID = " + this.id;
        }
    }
}

