/*
 * $Id$
 */

package org.apache.maven.plugin.lifecycle;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A phase mapping definition.
 * 
 * @version $Revision$ $Date$
 */
public class Phase implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The ID of this phase, eg <code>generate-sources</code>.
     */
    private String id;

    /**
     * Field executions.
     */
    private java.util.List executions;

    /**
     * Configuration to pass to all goals run in this phase.
     */
    private Object configuration;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExecution.
     * 
     * @param execution
     */
    public void addExecution( Execution execution )
    {
        if ( !(execution instanceof Execution) )
        {
            throw new ClassCastException( "Phase.addExecutions(execution) parameter must be instanceof " + Execution.class.getName() );
        }
        getExecutions().add( execution );
    } //-- void addExecution( Execution ) 

    /**
     * Get configuration to pass to all goals run in this phase.
     * 
     * @return Object
     */
    public Object getConfiguration()
    {
        return this.configuration;
    } //-- Object getConfiguration() 

    /**
     * Method getExecutions.
     * 
     * @return java.util.List
     */
    public java.util.List getExecutions()
    {
        if ( this.executions == null )
        {
            this.executions = new java.util.ArrayList();
        }
    
        return this.executions;
    } //-- java.util.List getExecutions() 

    /**
     * Get the ID of this phase, eg <code>generate-sources</code>.
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method removeExecution.
     * 
     * @param execution
     */
    public void removeExecution( Execution execution )
    {
        if ( !(execution instanceof Execution) )
        {
            throw new ClassCastException( "Phase.removeExecutions(execution) parameter must be instanceof " + Execution.class.getName() );
        }
        getExecutions().remove( execution );
    } //-- void removeExecution( Execution ) 

    /**
     * Set configuration to pass to all goals run in this phase.
     * 
     * @param configuration
     */
    public void setConfiguration( Object configuration )
    {
        this.configuration = configuration;
    } //-- void setConfiguration( Object ) 

    /**
     * Set the goals to execute within the phase.
     * 
     * @param executions
     */
    public void setExecutions( java.util.List executions )
    {
        this.executions = executions;
    } //-- void setExecutions( java.util.List ) 

    /**
     * Set the ID of this phase, eg <code>generate-sources</code>.
     * 
     * @param id
     */
    public void setId( String id )
    {
        this.id = id;
    } //-- void setId( String ) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
