/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.deployer;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataDeploymentException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.repository.legacy.WagonManager;
import org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformationManager;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;

@Component(role=ArtifactDeployer.class)
public class DefaultArtifactDeployer
extends AbstractLogEnabled
implements ArtifactDeployer {
    @Requirement
    private WagonManager wagonManager;
    @Requirement
    private ArtifactTransformationManager transformationManager;
    @Requirement
    private RepositoryMetadataManager repositoryMetadataManager;

    @Deprecated
    public void deploy(String basedir, String finalName, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        String extension = artifact.getArtifactHandler().getExtension();
        File source = new File(basedir, finalName + "." + extension);
        this.deploy(source, artifact, deploymentRepository, localRepository);
    }

    public void deploy(File source, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        try {
            this.transformationManager.transformForDeployment(artifact, deploymentRepository, localRepository);
            File artifactFile = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
            if (!artifactFile.equals(source)) {
                FileUtils.copyFile((File)source, (File)artifactFile);
            }
            this.wagonManager.putArtifact(source, artifact, deploymentRepository, null);
            for (ArtifactMetadata metadata : artifact.getMetadataList()) {
                this.repositoryMetadataManager.deploy(metadata, localRepository, deploymentRepository);
            }
        }
        catch (TransferFailedException e) {
            throw new ArtifactDeploymentException("Error deploying artifact: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ArtifactDeploymentException("Error deploying artifact: " + e.getMessage(), e);
        }
        catch (RepositoryMetadataDeploymentException e) {
            throw new ArtifactDeploymentException("Error installing artifact's metadata: " + e.getMessage(), e);
        }
    }
}

