/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.util.io.CachingWriter;

public class PomPropertiesUtil {
    private Properties loadPropertiesFile(File file) throws IOException {
        Properties fileProps = new Properties();
        try (InputStream istream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            fileProps.load(istream);
            Properties properties = fileProps;
            return properties;
        }
    }

    private void createPropertiesFile(Properties properties, Path outputFile) throws IOException {
        Path outputDir = outputFile.getParent();
        if (outputDir != null) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        properties.store(baos, null);
        String output = Arrays.stream(baos.toString(StandardCharsets.ISO_8859_1.name()).split("\\r?\\n")).filter(line -> !line.startsWith("#")).sorted().collect(Collectors.joining("\n", "", "\n"));
        try (CachingWriter writer = new CachingWriter(outputFile, StandardCharsets.ISO_8859_1);){
            writer.write(output);
        }
    }

    @Deprecated
    public void createPomProperties(MavenSession session, MavenProject project, Archiver archiver, File customPomPropertiesFile, File pomPropertiesFile, boolean forceCreation) throws IOException {
        this.createPomProperties(project, archiver, customPomPropertiesFile, pomPropertiesFile, forceCreation);
    }

    public void createPomProperties(MavenProject project, Archiver archiver, File customPomPropertiesFile, File pomPropertiesFile, boolean forceCreation) throws IOException {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        String version = project.getVersion();
        Properties p = customPomPropertiesFile != null ? this.loadPropertiesFile(customPomPropertiesFile) : new Properties();
        p.setProperty("groupId", groupId);
        p.setProperty("artifactId", artifactId);
        p.setProperty("version", version);
        this.createPropertiesFile(p, pomPropertiesFile.toPath());
        archiver.addFile(pomPropertiesFile, "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
    }
}

