/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.checksum;

import java.nio.file.Path;

public class WalkKey {
    private final Path normalized;
    private final String glob;
    private final boolean recursive;

    public WalkKey(Path normalized, String glob, boolean recursive) {
        this.normalized = normalized;
        this.glob = glob;
        this.recursive = recursive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WalkKey key = (WalkKey)o;
        if (this.recursive != key.recursive) {
            return false;
        }
        if (!this.normalized.equals(key.normalized)) {
            return false;
        }
        return this.glob.equals(key.glob);
    }

    public int hashCode() {
        int result = this.normalized.hashCode();
        result = 31 * result + this.glob.hashCode();
        result = 31 * result + (this.recursive ? 1 : 0);
        return result;
    }

    public Path getPath() {
        return this.normalized;
    }

    public String getGlob() {
        return this.glob;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public String toString() {
        return "WalkKey{normalized=" + this.normalized + ", glob='" + this.glob + '\'' + ", recursive=" + this.recursive + '}';
    }
}

