/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.buildcache.MultiModuleSupport;
import org.apache.maven.buildcache.NormalizedModelProvider;
import org.apache.maven.buildcache.ProjectInputCalculator;
import org.apache.maven.buildcache.RemoteCacheRepository;
import org.apache.maven.buildcache.checksum.MavenProjectInput;
import org.apache.maven.buildcache.xml.CacheConfig;
import org.apache.maven.buildcache.xml.build.ProjectsInputInfo;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
@Named
public class DefaultProjectInputCalculator
implements ProjectInputCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProjectInputCalculator.class);
    private final MavenSession mavenSession;
    private final RemoteCacheRepository remoteCache;
    private final CacheConfig cacheConfig;
    private final RepositorySystem repoSystem;
    private final NormalizedModelProvider normalizedModelProvider;
    private final MultiModuleSupport multiModuleSupport;
    private final ConcurrentMap<String, ProjectsInputInfo> checkSumMap = new ConcurrentHashMap<String, ProjectsInputInfo>();
    private static final ThreadLocal<Set<String>> CURRENTLY_CALCULATING = ThreadLocal.withInitial(LinkedHashSet::new);

    @Inject
    public DefaultProjectInputCalculator(MavenSession mavenSession, RemoteCacheRepository remoteCache, CacheConfig cacheConfig, RepositorySystem repoSystem, NormalizedModelProvider rawModelProvider, MultiModuleSupport multiModuleSupport) {
        this.mavenSession = mavenSession;
        this.remoteCache = remoteCache;
        this.cacheConfig = cacheConfig;
        this.repoSystem = repoSystem;
        this.normalizedModelProvider = rawModelProvider;
        this.multiModuleSupport = multiModuleSupport;
    }

    @Override
    public ProjectsInputInfo calculateInput(MavenProject project) {
        LOGGER.info("Going to calculate checksum for project [groupId={}, artifactId={}, version={}]", new Object[]{project.getGroupId(), project.getArtifactId(), project.getVersion()});
        String key = BuilderCommon.getKey((MavenProject)project);
        ProjectsInputInfo projectsInputInfo = (ProjectsInputInfo)this.checkSumMap.get(key);
        if (projectsInputInfo != null) {
            return projectsInputInfo;
        }
        projectsInputInfo = this.calculateInputInternal(key, project);
        this.checkSumMap.put(key, projectsInputInfo);
        return projectsInputInfo;
    }

    private ProjectsInputInfo calculateInputInternal(String key, MavenProject project) {
        Set<String> projectsSet = CURRENTLY_CALCULATING.get();
        if (!projectsSet.add(key)) {
            throw new IllegalStateException("Checksum for project is already calculating. Is there a cyclic dependencies? [project=" + key + ", setOfCalculatingProjects=" + projectsSet + "]");
        }
        try {
            MavenProjectInput input = new MavenProjectInput(project, this.normalizedModelProvider, this.multiModuleSupport, this, this.mavenSession, this.cacheConfig, this.repoSystem, this.remoteCache);
            ProjectsInputInfo projectsInputInfo = input.calculateChecksum();
            return projectsInputInfo;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate checksums for " + project.getArtifactId(), e);
        }
        finally {
            projectsSet.remove(key);
        }
    }
}

