/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.maven.doxia.site.Banner;
import org.apache.maven.doxia.site.Body;
import org.apache.maven.doxia.site.Image;
import org.apache.maven.doxia.site.LinkItem;
import org.apache.maven.doxia.site.Logo;
import org.apache.maven.doxia.site.Menu;
import org.apache.maven.doxia.site.MenuItem;
import org.apache.maven.doxia.site.PublishDate;
import org.apache.maven.doxia.site.SiteModel;
import org.apache.maven.doxia.site.Skin;
import org.apache.maven.doxia.site.Version;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class SiteXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, SiteModel siteModel) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(siteModel.getModelEncoding(), null);
        this.writeSiteModel(siteModel, "site", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, SiteModel siteModel) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, siteModel.getModelEncoding());
        serializer.startDocument(siteModel.getModelEncoding(), null);
        this.writeSiteModel(siteModel, "site", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeBanner(Banner banner, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (banner.getName() != null) {
            serializer.attribute(NAMESPACE, "name", banner.getName());
        }
        if (banner.getHref() != null) {
            serializer.attribute(NAMESPACE, "href", banner.getHref());
        }
        if (banner.getTarget() != null) {
            serializer.attribute(NAMESPACE, "target", banner.getTarget());
        }
        if (banner.getImage() != null) {
            this.writeImage(banner.getImage(), "image", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeBody(Body body, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (body.getHead() != null) {
            serializer.startTag(NAMESPACE, "head").text(body.getHead()).endTag(NAMESPACE, "head");
        }
        if (body.getLinks() != null && body.getLinks().size() > 0) {
            serializer.startTag(NAMESPACE, "links");
            for (LinkItem linkItem : body.getLinks()) {
                this.writeLinkItem(linkItem, "item", serializer);
            }
            serializer.endTag(NAMESPACE, "links");
        }
        if (body.getBreadcrumbs() != null && body.getBreadcrumbs().size() > 0) {
            serializer.startTag(NAMESPACE, "breadcrumbs");
            for (LinkItem linkItem : body.getBreadcrumbs()) {
                this.writeLinkItem(linkItem, "item", serializer);
            }
            serializer.endTag(NAMESPACE, "breadcrumbs");
        }
        if (body.getMenus() != null && body.getMenus().size() > 0) {
            for (Menu menu : body.getMenus()) {
                this.writeMenu(menu, "menu", serializer);
            }
        }
        if (body.getFooter() != null) {
            serializer.startTag(NAMESPACE, "footer").text(body.getFooter()).endTag(NAMESPACE, "footer");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeImage(Image image, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (image.getSrc() != null) {
            serializer.attribute(NAMESPACE, "src", image.getSrc());
        }
        if (image.getPosition() != null && !image.getPosition().equals("left")) {
            serializer.attribute(NAMESPACE, "position", image.getPosition());
        }
        if (image.getAlt() != null) {
            serializer.attribute(NAMESPACE, "alt", image.getAlt());
        }
        if (image.getWidth() != null) {
            serializer.attribute(NAMESPACE, "width", image.getWidth());
        }
        if (image.getHeight() != null) {
            serializer.attribute(NAMESPACE, "height", image.getHeight());
        }
        if (image.getStyle() != null) {
            serializer.attribute(NAMESPACE, "style", image.getStyle());
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeLinkItem(LinkItem linkItem, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (linkItem.getName() != null) {
            serializer.attribute(NAMESPACE, "name", linkItem.getName());
        }
        if (linkItem.getHref() != null) {
            serializer.attribute(NAMESPACE, "href", linkItem.getHref());
        }
        if (linkItem.getTarget() != null) {
            serializer.attribute(NAMESPACE, "target", linkItem.getTarget());
        }
        if (linkItem.getImage() != null) {
            this.writeImage(linkItem.getImage(), "image", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeLogo(Logo logo, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (logo.getName() != null) {
            serializer.attribute(NAMESPACE, "name", logo.getName());
        }
        if (logo.getHref() != null) {
            serializer.attribute(NAMESPACE, "href", logo.getHref());
        }
        if (logo.getTarget() != null) {
            serializer.attribute(NAMESPACE, "target", logo.getTarget());
        }
        if (logo.getImage() != null) {
            this.writeImage(logo.getImage(), "image", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeMenu(Menu menu, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (menu.getName() != null) {
            serializer.attribute(NAMESPACE, "name", menu.getName());
        }
        if (menu.getInherit() != null) {
            serializer.attribute(NAMESPACE, "inherit", menu.getInherit());
        }
        if (menu.isInheritAsRef()) {
            serializer.attribute(NAMESPACE, "inheritAsRef", String.valueOf(menu.isInheritAsRef()));
        }
        if (menu.getRef() != null) {
            serializer.attribute(NAMESPACE, "ref", menu.getRef());
        }
        if (menu.getImage() != null) {
            this.writeImage(menu.getImage(), "image", serializer);
        }
        if (menu.getItems() != null && menu.getItems().size() > 0) {
            for (MenuItem o : menu.getItems()) {
                this.writeMenuItem(o, "item", serializer);
            }
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeMenuItem(MenuItem menuItem, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (menuItem.isCollapse()) {
            serializer.attribute(NAMESPACE, "collapse", String.valueOf(menuItem.isCollapse()));
        }
        if (menuItem.getRef() != null) {
            serializer.attribute(NAMESPACE, "ref", menuItem.getRef());
        }
        if (menuItem.getName() != null) {
            serializer.attribute(NAMESPACE, "name", menuItem.getName());
        }
        if (menuItem.getHref() != null) {
            serializer.attribute(NAMESPACE, "href", menuItem.getHref());
        }
        if (menuItem.getTarget() != null) {
            serializer.attribute(NAMESPACE, "target", menuItem.getTarget());
        }
        if (menuItem.getItems() != null && menuItem.getItems().size() > 0) {
            for (MenuItem o : menuItem.getItems()) {
                this.writeMenuItem(o, "item", serializer);
            }
        }
        if (menuItem.getImage() != null) {
            this.writeImage(menuItem.getImage(), "image", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePublishDate(PublishDate publishDate, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (publishDate.getPosition() != null && !publishDate.getPosition().equals("left")) {
            serializer.attribute(NAMESPACE, "position", publishDate.getPosition());
        }
        if (publishDate.getFormat() != null && !publishDate.getFormat().equals("yyyy-MM-dd")) {
            serializer.attribute(NAMESPACE, "format", publishDate.getFormat());
        }
        if (publishDate.getTimezone() != null && !publishDate.getTimezone().equals("Etc/UTC")) {
            serializer.attribute(NAMESPACE, "timezone", publishDate.getTimezone());
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeSiteModel(SiteModel siteModel, String tagName, XmlSerializer serializer) throws IOException {
        if (this.fileComment != null) {
            serializer.comment(this.fileComment);
        }
        serializer.setPrefix("", "http://maven.apache.org/SITE/2.0.0");
        serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/SITE/2.0.0 https://maven.apache.org/xsd/site-2.0.0.xsd");
        if (siteModel.getName() != null) {
            serializer.attribute(NAMESPACE, "name", siteModel.getName());
        }
        if (siteModel.getCombineSelf() != null && !siteModel.getCombineSelf().equals("merge")) {
            serializer.attribute(NAMESPACE, "combine.self", siteModel.getCombineSelf());
        }
        if (siteModel.getBannerLeft() != null) {
            this.writeBanner(siteModel.getBannerLeft(), "bannerLeft", serializer);
        }
        if (siteModel.getBannerRight() != null) {
            this.writeBanner(siteModel.getBannerRight(), "bannerRight", serializer);
        }
        if (siteModel.getPublishDate() != null) {
            this.writePublishDate(siteModel.getPublishDate(), "publishDate", serializer);
        }
        if (siteModel.getVersion() != null) {
            this.writeVersion(siteModel.getVersion(), "version", serializer);
        }
        if (siteModel.getEdit() != null) {
            serializer.startTag(NAMESPACE, "edit").text(siteModel.getEdit()).endTag(NAMESPACE, "edit");
        }
        if (siteModel.getPoweredBy() != null && siteModel.getPoweredBy().size() > 0) {
            serializer.startTag(NAMESPACE, "poweredBy");
            for (Logo o : siteModel.getPoweredBy()) {
                this.writeLogo(o, "logo", serializer);
            }
            serializer.endTag(NAMESPACE, "poweredBy");
        }
        if (siteModel.getSkin() != null) {
            this.writeSkin(siteModel.getSkin(), "skin", serializer);
        }
        if (siteModel.getBody() != null) {
            this.writeBody(siteModel.getBody(), "body", serializer);
        }
        if (siteModel.getCustom() != null) {
            ((Xpp3Dom)siteModel.getCustom()).writeToSerializer(NAMESPACE, serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeSkin(Skin skin, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (skin.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "groupId").text(skin.getGroupId()).endTag(NAMESPACE, "groupId");
        }
        if (skin.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "artifactId").text(skin.getArtifactId()).endTag(NAMESPACE, "artifactId");
        }
        if (skin.getVersion() != null) {
            serializer.startTag(NAMESPACE, "version").text(skin.getVersion()).endTag(NAMESPACE, "version");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeVersion(Version version, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (version.getPosition() != null && !version.getPosition().equals("left")) {
            serializer.attribute(NAMESPACE, "position", version.getPosition());
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

