/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.doxia.site.Image;
import org.apache.maven.doxia.site.MenuItem;

public class Menu
implements Serializable,
Cloneable {
    private String name;
    private String inherit;
    private boolean inheritAsRef = false;
    private String ref;
    private Image image;
    private List<MenuItem> items;

    public void addItem(MenuItem menuItem) {
        this.getItems().add(menuItem);
    }

    public Menu clone() {
        try {
            Menu copy = (Menu)super.clone();
            if (this.image != null) {
                copy.image = this.image.clone();
            }
            if (this.items != null) {
                copy.items = new ArrayList<MenuItem>();
                for (MenuItem item : this.items) {
                    copy.items.add(item.clone());
                }
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Menu)) {
            return false;
        }
        Menu that = (Menu)other;
        boolean result = true;
        boolean bl = result && (this.getName() == null ? that.getName() == null : this.getName().equals(that.getName())) ? true : (result = false);
        boolean bl2 = result && (this.getInherit() == null ? that.getInherit() == null : this.getInherit().equals(that.getInherit())) ? true : (result = false);
        boolean bl3 = result && (this.getRef() == null ? that.getRef() == null : this.getRef().equals(that.getRef())) ? true : (result = false);
        boolean bl4 = result && (this.getImage() == null ? that.getImage() == null : this.getImage().equals(that.getImage())) ? true : (result = false);
        result = result && (this.getItems() == null ? that.getItems() == null : this.getItems().equals(that.getItems()));
        return result;
    }

    public Image getImage() {
        return this.image;
    }

    public String getInherit() {
        return this.inherit;
    }

    public List<MenuItem> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<MenuItem>();
        }
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public String getRef() {
        return this.ref;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 37 * result + (this.inherit != null ? this.inherit.hashCode() : 0);
        result = 37 * result + (this.ref != null ? this.ref.hashCode() : 0);
        result = 37 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 37 * result + (this.items != null ? this.items.hashCode() : 0);
        return result;
    }

    public boolean isInheritAsRef() {
        return this.inheritAsRef;
    }

    public void removeItem(MenuItem menuItem) {
        this.getItems().remove(menuItem);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setInherit(String inherit) {
        this.inherit = inherit;
    }

    public void setInheritAsRef(boolean inheritAsRef) {
        this.inheritAsRef = inheritAsRef;
    }

    public void setItems(List<MenuItem> items) {
        this.items = items;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("name = '");
        buf.append(this.getName());
        buf.append("'");
        buf.append("\n");
        buf.append("inherit = '");
        buf.append(this.getInherit());
        buf.append("'");
        buf.append("\n");
        buf.append("ref = '");
        buf.append(this.getRef());
        buf.append("'");
        buf.append("\n");
        buf.append("image = '");
        buf.append(this.getImage());
        buf.append("'");
        buf.append("\n");
        buf.append("items = '");
        buf.append(this.getItems());
        buf.append("'");
        return buf.toString();
    }
}

