/*
 * $Id$
 */

package org.apache.maven.doxia.module.fml.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         A Faq.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Faq implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The FAQ identifier.
     *           
     */
    private String id;

    /**
     * 
     *             The question.
     *           
     */
    private String question;

    /**
     * 
     *             The answer.
     *           
     */
    private String answer;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof Faq) )
        {
            return false;
        }
        
        Faq that = (Faq) other;
        boolean result = true;
        
        result = result && ( getId() == null ? that.getId() == null : getId().equals( that.getId() ) );
        result = result && ( getQuestion() == null ? that.getQuestion() == null : getQuestion().equals( that.getQuestion() ) );
        result = result && ( getAnswer() == null ? that.getAnswer() == null : getAnswer().equals( that.getAnswer() ) );
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get 
     *             The answer.
     *           
     * 
     * @return String
     */
    public String getAnswer()
    {
        return this.answer;
    } //-- String getAnswer() 

    /**
     * Get 
     *             The FAQ identifier.
     *           
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get 
     *             The question.
     *           
     * 
     * @return String
     */
    public String getQuestion()
    {
        return this.question;
    } //-- String getQuestion() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + ( id != null ? id.hashCode() : 0 );
        result = 37 * result + ( question != null ? question.hashCode() : 0 );
        result = 37 * result + ( answer != null ? answer.hashCode() : 0 );
        
        return result;
    } //-- int hashCode() 

    /**
     * Set 
     *             The answer.
     *           
     * 
     * @param answer
     */
    public void setAnswer(String answer)
    {
        this.answer = answer;
    } //-- void setAnswer(String) 

    /**
     * Set 
     *             The FAQ identifier.
     *           
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             The question.
     *           
     * 
     * @param question
     */
    public void setQuestion(String question)
    {
        this.question = question;
    } //-- void setQuestion(String) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "id = '" );
        buf.append( getId() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "question = '" );
        buf.append( getQuestion() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "answer = '" );
        buf.append( getAnswer() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
