/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.spatial3d.PointInShapeIntersectVisitor;
import org.apache.lucene.spatial3d.geom.BasePlanetObject;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.XYZBounds;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.RamUsageEstimator;

final class PointInGeo3DShapeQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(PointInGeo3DShapeQuery.class);
    final String field;
    final GeoShape shape;
    final XYZBounds shapeBounds;

    public PointInGeo3DShapeQuery(String field, GeoShape shape) {
        BasePlanetObject planetObject;
        this.field = field;
        this.shape = shape;
        this.shapeBounds = new XYZBounds();
        shape.getBounds(this.shapeBounds);
        if (shape instanceof BasePlanetObject && !(planetObject = (BasePlanetObject)((Object)shape)).getPlanetModel().equals(PlanetModel.WGS84)) {
            throw new IllegalArgumentException("this qurey requires PlanetModel.WGS84, but got: " + planetObject.getPlanetModel());
        }
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                PointValues values = reader.getPointValues(PointInGeo3DShapeQuery.this.field);
                if (values == null) {
                    return null;
                }
                DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values, PointInGeo3DShapeQuery.this.field);
                values.intersect((PointValues.IntersectVisitor)new PointInShapeIntersectVisitor(result, PointInGeo3DShapeQuery.this.shape, PointInGeo3DShapeQuery.this.shapeBounds));
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, result.build().iterator());
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public GeoShape getShape() {
        return this.shape;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((PointInGeo3DShapeQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(PointInGeo3DShapeQuery other) {
        return this.field.equals(other.field) && this.shape.equals(other.shape);
    }

    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.shape.hashCode();
        return result;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(" Shape: ");
        sb.append(this.shape);
        return sb.toString();
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject((Object)this.field) + RamUsageEstimator.sizeOfObject((Object)this.shape) + RamUsageEstimator.sizeOfObject((Object)this.shapeBounds);
    }
}

