/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.term;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.grouping.AbstractDistinctValuesCollector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SentinelIntSet;

public class TermDistinctValuesCollector
extends AbstractDistinctValuesCollector<GroupCount> {
    private final String groupField;
    private final String countField;
    private final List<GroupCount> groups;
    private final SentinelIntSet ordSet;
    private final GroupCount[] groupCounts;
    private SortedDocValues groupFieldTermIndex;
    private SortedDocValues countFieldTermIndex;

    public TermDistinctValuesCollector(String groupField, String countField, Collection<SearchGroup<BytesRef>> groups) {
        this.groupField = groupField;
        this.countField = countField;
        this.groups = new ArrayList<GroupCount>(groups.size());
        for (SearchGroup<BytesRef> group : groups) {
            this.groups.add(new GroupCount((BytesRef)group.groupValue));
        }
        this.ordSet = new SentinelIntSet(groups.size(), -2);
        this.groupCounts = new GroupCount[this.ordSet.keys.length];
    }

    public void collect(int doc) throws IOException {
        int slot = this.ordSet.find(this.groupFieldTermIndex.getOrd(doc));
        if (slot < 0) {
            return;
        }
        GroupCount gc = this.groupCounts[slot];
        int countOrd = this.countFieldTermIndex.getOrd(doc);
        if (this.doesNotContainOrd(countOrd, gc.ords)) {
            if (countOrd == -1) {
                gc.uniqueValues.add(null);
            } else {
                BytesRef term = BytesRef.deepCopyOf((BytesRef)this.countFieldTermIndex.lookupOrd(countOrd));
                gc.uniqueValues.add(term);
            }
            gc.ords = Arrays.copyOf(gc.ords, gc.ords.length + 1);
            gc.ords[gc.ords.length - 1] = countOrd;
            if (gc.ords.length > 1) {
                Arrays.sort(gc.ords);
            }
        }
    }

    private boolean doesNotContainOrd(int ord, int[] ords) {
        if (ords.length == 0) {
            return true;
        }
        if (ords.length == 1) {
            return ord != ords[0];
        }
        return Arrays.binarySearch(ords, ord) < 0;
    }

    @Override
    public List<GroupCount> getGroups() {
        return this.groups;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.groupFieldTermIndex = DocValues.getSorted((LeafReader)context.reader(), (String)this.groupField);
        this.countFieldTermIndex = DocValues.getSorted((LeafReader)context.reader(), (String)this.countField);
        this.ordSet.clear();
        for (GroupCount group : this.groups) {
            int groupOrd;
            int n = groupOrd = group.groupValue == null ? -1 : this.groupFieldTermIndex.lookupTerm((BytesRef)group.groupValue);
            if (group.groupValue != null && groupOrd < 0) continue;
            this.groupCounts[this.ordSet.put((int)groupOrd)] = group;
            group.ords = new int[group.uniqueValues.size()];
            Arrays.fill(group.ords, -2);
            int i = 0;
            for (BytesRef value : group.uniqueValues) {
                int countOrd;
                int n2 = countOrd = value == null ? -1 : this.countFieldTermIndex.lookupTerm(value);
                if (value != null && countOrd < 0) continue;
                group.ords[i++] = countOrd;
            }
        }
    }

    public boolean needsScores() {
        return true;
    }

    public static class GroupCount
    extends AbstractDistinctValuesCollector.GroupCount<BytesRef> {
        int[] ords;

        GroupCount(BytesRef groupValue) {
            super(groupValue);
        }
    }
}

