/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class StopFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet stopWords;
    private boolean ignoreCase;
    private boolean enablePositionIncrements;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.assureMatchVersion();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        String stopWordFiles = (String)this.args.get("words");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
        this.stopWords = stopWordFiles != null ? ("snowball".equalsIgnoreCase((String)this.args.get("format")) ? this.getSnowballWordSet(loader, stopWordFiles, this.ignoreCase) : this.getWordSet(loader, stopWordFiles, this.ignoreCase)) : new CharArraySet(this.luceneMatchVersion, StopAnalyzer.ENGLISH_STOP_WORDS_SET, this.ignoreCase);
    }

    public boolean isEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public CharArraySet getStopWords() {
        return this.stopWords;
    }

    @Override
    public TokenStream create(TokenStream input) {
        StopFilter stopFilter = new StopFilter(this.luceneMatchVersion, input, this.stopWords);
        stopFilter.setEnablePositionIncrements(this.enablePositionIncrements);
        return stopFilter;
    }
}

