/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.main;

import java.util.Arrays;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.query.TxnType;
import org.apache.jena.tdb2.loader.base.BulkStartFinish;
import org.apache.jena.tdb2.loader.base.CoLib;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;

public class IndexerInline
implements BulkStartFinish {
    private final int N;
    private final MonitorOutput output;
    private TupleIndex[] indexes;
    private TransactionCoordinator coordinator;
    private Transaction transaction;

    public IndexerInline(MonitorOutput output, TupleIndex ... idxTriples) {
        this.N = idxTriples.length;
        this.indexes = Arrays.copyOf(idxTriples, this.N);
        this.output = output;
    }

    @Override
    public void startBulk() {
        TransactionCoordinator coordinator = CoLib.newCoordinator();
        Arrays.stream(this.indexes).forEach(idx -> CoLib.add(coordinator, idx));
        CoLib.start(coordinator);
        this.transaction = coordinator.begin(TxnType.WRITE);
    }

    @Override
    public void finishBulk() {
        this.transaction.commit();
        this.transaction.end();
        CoLib.finish(this.coordinator);
    }

    public void load(Tuple<NodeId> tuple) {
        for (TupleIndex idx : this.indexes) {
            idx.add(tuple);
        }
    }
}

