/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.index;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.index.IndexChange;

public interface Index
extends Iterable<Record>,
Sync,
Closeable {
    public Record find(Record var1);

    public boolean contains(Record var1);

    public boolean insert(Record var1);

    public boolean delete(Record var1);

    default public void bulkChanges(Stream<IndexChange> changes) {
        changes.forEach(chg -> {
            switch (chg.action) {
                case ADD: {
                    this.insert(chg.record);
                    break;
                }
                case DELETE: {
                    this.delete(chg.record);
                }
            }
        });
    }

    @Override
    public Iterator<Record> iterator();

    public RecordFactory getRecordFactory();

    public void close();

    public boolean isEmpty();

    public void clear();

    public void check();

    public long size();
}

