/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.hwpf.model.PropertyNode;

public abstract class BytePropertyNode
extends PropertyNode {
    private boolean isUnicode;

    public BytePropertyNode(int fcStart, int fcEnd, Object buf, boolean isUnicode) {
        super(BytePropertyNode.generateCp(fcStart, isUnicode), BytePropertyNode.generateCp(fcEnd, isUnicode), buf);
        this.isUnicode = isUnicode;
    }

    private static int generateCp(int val, boolean isUnicode) {
        if (isUnicode) {
            return val / 2;
        }
        return val;
    }

    public boolean isUnicode() {
        return this.isUnicode;
    }

    public int getStartBytes() {
        if (this.isUnicode) {
            return this.getStart() * 2;
        }
        return this.getStart();
    }

    public int getEndBytes() {
        if (this.isUnicode) {
            return this.getEnd() * 2;
        }
        return this.getEnd();
    }
}

