/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.api.security.principal.NoSuchPrincipalException;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.user.GroupImpl;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AuthorizableImpl
implements Authorizable,
UserConstants {
    static final Logger log = LoggerFactory.getLogger(AuthorizableImpl.class);
    final UserManagerImpl userManager;
    private final NodeImpl node;

    protected AuthorizableImpl(NodeImpl node, UserManagerImpl userManager) throws RepositoryException {
        if (!node.isNodeType(NT_REP_AUTHORIZABLE)) {
            throw new IllegalArgumentException("Node argument of NodeType " + NT_REP_AUTHORIZABLE + " required");
        }
        this.node = node;
        this.userManager = userManager;
    }

    public PrincipalIterator getPrincipals() throws RepositoryException {
        ArrayList<Principal> coll = new ArrayList<Principal>();
        coll.add(this.getPrincipal());
        PrincipalManager prMgr = this.getSession().getPrincipalManager();
        Iterator it = this.getRefereeValues().iterator();
        while (it.hasNext()) {
            String refName = ((Value)it.next()).getString();
            Principal princ = null;
            if (prMgr.hasPrincipal(refName)) {
                try {
                    princ = prMgr.getPrincipal(refName);
                }
                catch (NoSuchPrincipalException e) {
                    // empty catch block
                }
            }
            if (princ == null) {
                log.warn("Principal " + refName + " unknown to PrincipalManager.");
                princ = new PrincipalImpl(refName);
            }
            coll.add(princ);
        }
        return new PrincipalIteratorAdapter(coll);
    }

    public synchronized boolean addReferee(Principal principal) throws RepositoryException {
        String principalName = principal.getName();
        Value princValue = this.getSession().getValueFactory().createValue(principalName);
        List refereeValues = this.getRefereeValues();
        if (refereeValues.contains(princValue) || this.getPrincipal().getName().equals(principalName)) {
            return false;
        }
        if (this.userManager.hasAuthorizableOrReferee(principal)) {
            throw new AuthorizableExistsException("Another authorizable already represented by or refeering to " + principalName);
        }
        refereeValues.add(princValue);
        this.userManager.setProtectedProperty(this.node, P_REFEREES, refereeValues.toArray(new Value[refereeValues.size()]));
        return true;
    }

    public synchronized boolean removeReferee(Principal principal) throws RepositoryException {
        Value princValue = this.getSession().getValueFactory().createValue(principal.getName());
        List existingValues = this.getRefereeValues();
        if (existingValues.remove(princValue)) {
            PropertyImpl prop = this.node.getProperty(P_REFEREES);
            if (existingValues.isEmpty()) {
                this.userManager.removeProtectedItem(prop, this.node);
            } else {
                this.userManager.setProtectedProperty(this.node, P_REFEREES, existingValues.toArray(new Value[existingValues.size()]));
            }
            return true;
        }
        return false;
    }

    public Iterator declaredMemberOf() throws RepositoryException {
        ArrayList memberShip = new ArrayList();
        this.collectMembership(memberShip, false);
        return memberShip.iterator();
    }

    public Iterator memberOf() throws RepositoryException {
        ArrayList memberShip = new ArrayList();
        this.collectMembership(memberShip, true);
        return memberShip.iterator();
    }

    public Iterator getPropertyNames() throws RepositoryException {
        ArrayList<String> l = new ArrayList<String>();
        PropertyIterator it = this.node.getProperties();
        while (it.hasNext()) {
            Property prop = it.nextProperty();
            if (!AuthorizableImpl.isAuthorizableProperty(prop)) continue;
            l.add(prop.getName());
        }
        return l.iterator();
    }

    public boolean hasProperty(String name) throws RepositoryException {
        return this.node.hasProperty(name) && AuthorizableImpl.isAuthorizableProperty(this.node.getProperty(name));
    }

    public Value[] getProperty(String name) throws RepositoryException {
        PropertyImpl prop;
        if (this.hasProperty(name) && AuthorizableImpl.isAuthorizableProperty(prop = (PropertyImpl)this.node.getProperty(name))) {
            if (prop.isMultiple()) {
                return prop.getValues();
            }
            return new Value[]{prop.getValue()};
        }
        return null;
    }

    public synchronized void setProperty(String name, Value value) throws RepositoryException {
        this.checkProtectedProperty(name);
        try {
            this.node.setProperty(name, value);
            this.node.save();
        }
        catch (RepositoryException e) {
            log.warn("Failed to set Property " + name + " for Authorizable " + this.getID());
            this.node.refresh(false);
            throw e;
        }
    }

    public synchronized void setProperty(String name, Value[] values) throws RepositoryException {
        this.checkProtectedProperty(name);
        try {
            this.node.setProperty(name, values);
            this.node.save();
        }
        catch (RepositoryException e) {
            log.warn("Failed to set Property " + name + " for Authorizable " + this.getID());
            this.node.refresh(false);
            throw e;
        }
    }

    public synchronized boolean removeProperty(String name) throws RepositoryException {
        this.checkProtectedProperty(name);
        try {
            if (this.node.hasProperty(name)) {
                PropertyImpl p = (PropertyImpl)this.node.getProperty(name);
                if (p.isMultiple()) {
                    p.setValue((Value[])null);
                } else {
                    p.setValue((Value)null);
                }
                this.node.save();
                return true;
            }
            return false;
        }
        catch (RepositoryException e) {
            log.warn("Failed to remove Property " + name + " from Authorizable " + this.getID());
            this.node.refresh(false);
            throw e;
        }
    }

    public synchronized void remove() throws RepositoryException {
        if (!this.isGroup() && ((User)((Object)this)).isAdmin()) {
            throw new RepositoryException("The administrator cannot be removed.");
        }
        this.userManager.removeProtectedItem(this.node, this.node.getParent());
    }

    NodeImpl getNode() {
        return this.node;
    }

    SessionImpl getSession() throws RepositoryException {
        return (SessionImpl)this.node.getSession();
    }

    String getPrincipalName() throws RepositoryException {
        return this.node.getProperty(P_PRINCIPAL_NAME).getString();
    }

    boolean addToGroup(GroupImpl group) throws RepositoryException {
        try {
            Value[] values;
            Value added = this.getSession().getValueFactory().createValue(group.getNode());
            NodeImpl node = this.getNode();
            if (node.hasProperty(P_GROUPS)) {
                Value[] old = node.getProperty(P_GROUPS).getValues();
                values = new Value[old.length + 1];
                System.arraycopy(old, 0, values, 0, old.length);
            } else {
                values = new Value[1];
            }
            values[values.length - 1] = added;
            this.userManager.setProtectedProperty(node, P_GROUPS, values);
            return true;
        }
        catch (RepositoryException e) {
            log.warn("Error while editing group membership:", (Object)e.getMessage());
            this.getSession().refresh(false);
            throw e;
        }
    }

    boolean removeFromGroup(GroupImpl group) throws RepositoryException {
        NodeImpl node = this.getNode();
        String message = "Authorizable " + this.getID() + " is not member of " + group.getID();
        if (!node.hasProperty(P_GROUPS)) {
            log.debug(message);
            return false;
        }
        Value toRemove = this.getSession().getValueFactory().createValue(group.getNode());
        PropertyImpl property = node.getProperty(P_GROUPS);
        ArrayList<Value> valList = new ArrayList<Value>(Arrays.asList(property.getValues()));
        if (valList.remove(toRemove)) {
            try {
                if (valList.isEmpty()) {
                    this.userManager.removeProtectedItem(property, node);
                } else {
                    Value[] values = valList.toArray(new Value[valList.size()]);
                    this.userManager.setProtectedProperty(node, P_GROUPS, values);
                }
                return true;
            }
            catch (RepositoryException e) {
                node.refresh(false);
                throw e;
            }
        }
        log.debug(message);
        return false;
    }

    private void collectMembership(List groups, boolean includedIndirect) throws RepositoryException {
        NodeImpl node = this.getNode();
        if (!node.hasProperty(P_GROUPS)) {
            return;
        }
        Value[] refs = node.getProperty(P_GROUPS).getValues();
        for (int i = 0; i < refs.length; ++i) {
            NodeImpl groupNode = (NodeImpl)this.getSession().getNodeByUUID(refs[i].getString());
            Group group = GroupImpl.create(groupNode, this.userManager);
            if (!groups.add(group) || !includedIndirect) continue;
            ((AuthorizableImpl)((Object)group)).collectMembership(groups, true);
        }
    }

    private static boolean isAuthorizableProperty(Property prop) throws RepositoryException {
        PropertyDefinition def = prop.getDefinition();
        if (def.isProtected()) {
            return false;
        }
        NodeTypeImpl declaringNt = (NodeTypeImpl)prop.getDefinition().getDeclaringNodeType();
        return declaringNt.isNodeType(UserConstants.NT_REP_AUTHORIZABLE);
    }

    private boolean isProtectedProperty(String propertyName) throws RepositoryException {
        Name pName = this.getSession().getQName(propertyName);
        return P_PRINCIPAL_NAME.equals(pName) || P_USERID.equals(pName) || P_REFEREES.equals(pName) || P_GROUPS.equals(pName) || P_IMPERSONATORS.equals(pName) || P_PASSWORD.equals(pName);
    }

    private void checkProtectedProperty(String propertyName) throws ConstraintViolationException, RepositoryException {
        if (this.isProtectedProperty(propertyName)) {
            throw new ConstraintViolationException("Attempt to modify protected property " + propertyName + " of an Authorizable.");
        }
    }

    private List getRefereeValues() throws RepositoryException {
        ArrayList<Value> principalNames = new ArrayList<Value>();
        if (this.node.hasProperty(P_REFEREES)) {
            try {
                Value[] refProp = this.node.getProperty(P_REFEREES).getValues();
                for (int i = 0; i < refProp.length; ++i) {
                    principalNames.add(refProp[i]);
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
        return principalNames;
    }

    class NodeBasedPrincipal
    extends PrincipalImpl
    implements ItemBasedPrincipal {
        NodeBasedPrincipal(String name) {
            super(name);
        }

        public String getPath() throws RepositoryException {
            return AuthorizableImpl.this.node.getPath();
        }
    }
}

