/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.config;

import java.net.InetAddress;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.junit.Test;

public class TestRequestConfig {
    @Test
    public void testBasics() {
        RequestConfig config = RequestConfig.custom().build();
        config.toString();
    }

    @Test
    public void testDefaults() {
        RequestConfig config = RequestConfig.DEFAULT;
        Assert.assertEquals((int)-1, (int)config.getSocketTimeout());
        Assert.assertEquals((int)-1, (int)config.getConnectTimeout());
        Assert.assertEquals((int)-1, (int)config.getConnectionRequestTimeout());
        Assert.assertEquals((boolean)false, (boolean)config.isExpectContinueEnabled());
        Assert.assertEquals((boolean)true, (boolean)config.isStaleConnectionCheckEnabled());
        Assert.assertEquals((boolean)true, (boolean)config.isAuthenticationEnabled());
        Assert.assertEquals((boolean)true, (boolean)config.isRedirectsEnabled());
        Assert.assertEquals((boolean)true, (boolean)config.isRelativeRedirectsAllowed());
        Assert.assertEquals((boolean)false, (boolean)config.isCircularRedirectsAllowed());
        Assert.assertEquals((int)50, (int)config.getMaxRedirects());
        Assert.assertEquals(null, (String)config.getCookieSpec());
        Assert.assertEquals(null, (Object)config.getLocalAddress());
        Assert.assertEquals(null, (Object)config.getProxy());
        Assert.assertEquals(null, (Object)config.getTargetPreferredAuthSchemes());
        Assert.assertEquals(null, (Object)config.getProxyPreferredAuthSchemes());
    }

    @Test
    public void testBuildAndCopy() throws Exception {
        RequestConfig config0 = RequestConfig.custom().setSocketTimeout(22).setConnectTimeout(33).setConnectionRequestTimeout(44).setExpectContinueEnabled(true).setStaleConnectionCheckEnabled(false).setAuthenticationEnabled(false).setRedirectsEnabled(false).setRelativeRedirectsAllowed(false).setCircularRedirectsAllowed(true).setMaxRedirects(100).setCookieSpec("standard").setLocalAddress(InetAddress.getLocalHost()).setProxy(new HttpHost("someproxy")).setTargetPreferredAuthSchemes(Arrays.asList("NTLM")).setProxyPreferredAuthSchemes(Arrays.asList("Digest")).build();
        RequestConfig config = RequestConfig.copy((RequestConfig)config0).build();
        Assert.assertEquals((int)22, (int)config.getSocketTimeout());
        Assert.assertEquals((int)33, (int)config.getConnectTimeout());
        Assert.assertEquals((int)44, (int)config.getConnectionRequestTimeout());
        Assert.assertEquals((boolean)true, (boolean)config.isExpectContinueEnabled());
        Assert.assertEquals((boolean)false, (boolean)config.isStaleConnectionCheckEnabled());
        Assert.assertEquals((boolean)false, (boolean)config.isAuthenticationEnabled());
        Assert.assertEquals((boolean)false, (boolean)config.isRedirectsEnabled());
        Assert.assertEquals((boolean)false, (boolean)config.isRelativeRedirectsAllowed());
        Assert.assertEquals((boolean)true, (boolean)config.isCircularRedirectsAllowed());
        Assert.assertEquals((int)100, (int)config.getMaxRedirects());
        Assert.assertEquals((String)"standard", (String)config.getCookieSpec());
        Assert.assertEquals((Object)InetAddress.getLocalHost(), (Object)config.getLocalAddress());
        Assert.assertEquals((Object)new HttpHost("someproxy"), (Object)config.getProxy());
        Assert.assertEquals(Arrays.asList("NTLM"), (Object)config.getTargetPreferredAuthSchemes());
        Assert.assertEquals(Arrays.asList("Digest"), (Object)config.getProxyPreferredAuthSchemes());
    }
}

