/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hbase.replication;

import java.util.List;

import org.apache.hadoop.hbase.classification.InterfaceAudience;

/**
 * The replication listener interface can be implemented if a class needs to subscribe to events
 * generated by the ReplicationTracker. These events include things like addition/deletion of peer
 * clusters or failure of a local region server. To receive events, the class also needs to register
 * itself with a Replication Tracker.
 */
@InterfaceAudience.Private
public interface ReplicationListener {

  /**
   * A region server has been removed from the local cluster
   * @param regionServer the removed region server
   */
  public void regionServerRemoved(String regionServer);

  /**
   * A peer cluster has been removed (i.e. unregistered) from replication.
   * @param peerId The peer id of the cluster that has been removed
   */
  public void peerRemoved(String peerId);

  /**
   * The list of registered peer clusters has changed.
   * @param peerIds A list of all currently registered peer clusters
   */
  public void peerListChanged(List<String> peerIds);
}
