/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;

@Metrics(name="LocalJobRunnerMetrics", context="mapred")
final class LocalJobRunnerMetrics {
    @Metric
    private MutableCounterInt numMapTasksLaunched;
    @Metric
    private MutableCounterInt numMapTasksCompleted;
    @Metric
    private MutableCounterInt numReduceTasksLaunched;
    @Metric
    private MutableGaugeInt numReduceTasksCompleted;

    private LocalJobRunnerMetrics() {
    }

    public static LocalJobRunnerMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.initialize((String)"JobTracker");
        return (LocalJobRunnerMetrics)ms.register("LocalJobRunnerMetrics-" + ThreadLocalRandom.current().nextInt(), null, (Object)new LocalJobRunnerMetrics());
    }

    public synchronized void launchMap(TaskAttemptID taskAttemptID) {
        this.numMapTasksLaunched.incr();
    }

    public void completeMap(TaskAttemptID taskAttemptID) {
        this.numMapTasksCompleted.incr();
    }

    public synchronized void launchReduce(TaskAttemptID taskAttemptID) {
        this.numReduceTasksLaunched.incr();
    }

    public void completeReduce(TaskAttemptID taskAttemptID) {
        this.numReduceTasksCompleted.incr();
    }
}

