/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.util.Map;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRates;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hadoop.metrics2.util.Quantile;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestMutableMetrics {
    private final double EPSILON = 1.0E-42;

    @Test
    public void testSnapshot() {
        MetricsRecordBuilder mb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        registry.newCounter("c1", "int counter", 1);
        registry.newCounter("c2", "long counter", 2L);
        registry.newGauge("g1", "int gauge", 3);
        registry.newGauge("g2", "long gauge", 4L);
        registry.newStat("s1", "stat", "Ops", "Time", true).add(0L);
        registry.newRate("s2", "stat", false).add(0L);
        registry.snapshot(mb, true);
        MutableStat s2 = (MutableStat)registry.get("s2");
        s2.snapshot(mb, true);
        s2.add(1L);
        s2.snapshot(mb, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addCounter(Interns.info((String)"c1", (String)"int counter"), 1);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addCounter(Interns.info((String)"c2", (String)"long counter"), 2L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)"g1", (String)"int gauge"), 3);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)"g2", (String)"long gauge"), 4L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addCounter(Interns.info((String)"S1NumOps", (String)"Number of ops for stat"), 1L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)Matchers.eq((Object)Interns.info((String)"S1AvgTime", (String)"Average time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)Matchers.eq((Object)Interns.info((String)"S1StdevTime", (String)"Standard deviation of time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)Matchers.eq((Object)Interns.info((String)"S1IMinTime", (String)"Interval min time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)Matchers.eq((Object)Interns.info((String)"S1IMaxTime", (String)"Interval max time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)Matchers.eq((Object)Interns.info((String)"S1MinTime", (String)"Min time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)Matchers.eq((Object)Interns.info((String)"S1MaxTime", (String)"Max time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)2))).addCounter(Interns.info((String)"S2NumOps", (String)"Number of ops for stat"), 1L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)2))).addGauge((MetricsInfo)Matchers.eq((Object)Interns.info((String)"S2AvgTime", (String)"Average time for stat")), AdditionalMatchers.eq((double)0.0, (double)1.0E-42));
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addCounter(Interns.info((String)"S2NumOps", (String)"Number of ops for stat"), 2L);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)Matchers.eq((Object)Interns.info((String)"S2AvgTime", (String)"Average time for stat")), AdditionalMatchers.eq((double)1.0, (double)1.0E-42));
    }

    @Test
    public void testMutableRates() {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        MutableRates rates = new MutableRates(registry);
        rates.init(TestProtocol.class);
        registry.snapshot(rb, false);
        MetricsAsserts.assertCounter("FooNumOps", 0L, rb);
        MetricsAsserts.assertGauge("FooAvgTime", 0.0, rb);
        MetricsAsserts.assertCounter("BarNumOps", 0L, rb);
        MetricsAsserts.assertGauge("BarAvgTime", 0.0, rb);
    }

    @Test(timeout=30000L)
    public void testMutableQuantilesError() throws Exception {
        MetricsRecordBuilder mb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        MutableQuantiles quantiles = registry.newQuantiles("foo", "stat", "Ops", "Latency", 5);
        long start = System.nanoTime() / 1000000L;
        for (long i = 1L; i <= 1000L; ++i) {
            quantiles.add(i);
            quantiles.add(1001L - i);
        }
        long end = System.nanoTime() / 1000000L;
        Thread.sleep(6000L - (end - start));
        registry.snapshot(mb, false);
        Map previousSnapshot = quantiles.previousSnapshot;
        for (Map.Entry item : previousSnapshot.entrySet()) {
            System.out.println(String.format("Quantile %.2f has value %d", ((Quantile)item.getKey()).quantile, item.getValue()));
        }
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)"FooNumOps", (String)"Number of ops for stat with 5s interval"), 2000L);
        Quantile[] quants = MutableQuantiles.quantiles;
        String name = "Foo%dthPercentileLatency";
        String desc = "%d percentile latency with 5 second interval for stat";
        for (Quantile q : quants) {
            int percentile = (int)(100.0 * q.quantile);
            int error = (int)(1000.0 * q.error);
            String n = String.format(name, percentile);
            String d = String.format(desc, percentile);
            long expected = (long)(q.quantile * 1000.0);
            ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)Matchers.eq((Object)Interns.info((String)n, (String)d)), AdditionalMatchers.leq((long)(expected + (long)error)));
            ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge((MetricsInfo)Matchers.eq((Object)Interns.info((String)n, (String)d)), AdditionalMatchers.geq((long)(expected - (long)error)));
        }
    }

    @Test(timeout=30000L)
    public void testMutableQuantilesRollover() throws Exception {
        MetricsRecordBuilder mb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        MutableQuantiles quantiles = registry.newQuantiles("foo", "stat", "Ops", "Latency", 5);
        Quantile[] quants = MutableQuantiles.quantiles;
        String name = "Foo%dthPercentileLatency";
        String desc = "%d percentile latency with 5 second interval for stat";
        long start = System.nanoTime() / 1000000L;
        for (int i = 1; i <= 3; ++i) {
            for (long j = 1L; j <= 1000L; ++j) {
                quantiles.add((long)i);
            }
            long sleep = start + (long)(5000 * i) + 1000L - System.nanoTime() / 1000000L;
            Thread.sleep(sleep);
            registry.snapshot(mb, false);
            for (Quantile q : quants) {
                int percentile = (int)(100.0 * q.quantile);
                String n = String.format(name, percentile);
                String d = String.format(desc, percentile);
                ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)n, (String)d), (long)i);
            }
        }
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)3))).addGauge(Interns.info((String)"FooNumOps", (String)"Number of ops for stat with 5s interval"), 1000L);
        for (Quantile q : quants) {
            int percentile = (int)(100.0 * q.quantile);
            String n = String.format(name, percentile);
            String d = String.format(desc, percentile);
            ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)3))).addGauge((MetricsInfo)Matchers.eq((Object)Interns.info((String)n, (String)d)), Matchers.anyLong());
        }
    }

    @Test(timeout=30000L)
    public void testMutableQuantilesEmptyRollover() throws Exception {
        MetricsRecordBuilder mb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsRegistry registry = new MetricsRegistry("test");
        MutableQuantiles quantiles = registry.newQuantiles("foo", "stat", "Ops", "Latency", 5);
        quantiles.snapshot(mb, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb)).addGauge(Interns.info((String)"FooNumOps", (String)"Number of ops for stat with 5s interval"), 0L);
        Thread.sleep(6000L);
        quantiles.snapshot(mb, false);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)2))).addGauge(Interns.info((String)"FooNumOps", (String)"Number of ops for stat with 5s interval"), 0L);
    }

    static interface TestProtocol {
        public void foo();

        public void bar();
    }
}

